package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.revenueAndExpenditure.RevenueAndExpenditureTools;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDiscard extends XMBaseTest {

    Tools tools=new Tools();

    OrderTools orderTools=new OrderTools();

    RevenueAndExpenditureTools revenueAndExpenditureTools=new RevenueAndExpenditureTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_discard")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "作废签单订单")
    public void testDiscard(){


        //获取会员ID
        String memberId=tools.search("NORMAL","NORMAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取会员卡信息
        //获取会员卡列表
        JSONObject memberCard=orderTools.fetchPageOfMemberCard(xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());
        String cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        int quantity= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("balance"));
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //检查会员对该卡是否超出购买上限
        boolean limitResult=orderTools.checkAllowPurchase("MEMBER_CARD",cardId,memberId,"1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        if(limitResult == true) {

            //创建订单
            JSONObject orderResult=orderTools.signOrder(cardId,latestSnapshotId,quantity,price,validPeriod,latestSnapshotId, price/2,"PURCHASE",
                    "MEMBER_CARD",memberId,price-price/2,price-price/2,"1");
            String success=orderResult.getString("success");
            String getDetailId=orderResult.getString("result");
            Assert.assertEquals(success,"true","创建订单失败");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            //获取订单详情
            JSONObject getDetailResult=orderTools.getDetail(getDetailId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());
            String id = getDetailResult.getJSONObject("result").getString("id");
            String businessNo = getDetailResult.getJSONObject("result").getString("businessNo");
            Assert.assertEquals(id.equals(getDetailId),true,"获取创建的订单详情失败");


            //校验是否可以作废订单

            boolean checkDiscardVoucherResult=orderTools.checkDiscardVoucher(getDetailId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

            if(checkDiscardVoucherResult==true){

                JSONObject discardResult=orderTools.discard(getDetailId,"重复录入","已作废签单订单"+ RandomStringUtil.randomString(10),
                        xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());
                String discardSuccess=discardResult.getString("success");
                Assert.assertEquals(discardSuccess,"true","签单订单作废失败");

                //验证订单状态

                //获取订单详情--订单状态：已作废
                JSONObject getDetailResult1=orderTools.getDetail(getDetailId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());
                String state = getDetailResult1.getJSONObject("result").getString("state");
                Assert.assertEquals(state,"DISCARD","签单订单作废失败");


                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }

                //获取订单支付记录--支付记录被作废
                JSONObject listByVoucherIdResult=orderTools.listByVoucherId(getDetailId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());
                String listByVoucherId=listByVoucherIdResult.getJSONArray("result").getJSONObject(0).getString("id");//收支的id
                String listByVoucherState=listByVoucherIdResult.getJSONArray("result").getJSONObject(0).getString("state");
                String paymentWayId=listByVoucherIdResult.getJSONArray("result").getJSONObject(0).getJSONObject("paymentWay").getString("id");
                Assert.assertEquals(listByVoucherState,"DISCARD","签单订单的支付记录未被作废");


                //获取已作废收支明细
                JSONObject pageDiscardIncomeExpenseResult=revenueAndExpenditureTools.pageDiscardIncomeExpense(paymentWayId,"INCOME", "SIGN",
                        xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());

                int pageDiscardIncomeExpensePages=Integer.parseInt(pageDiscardIncomeExpenseResult.getJSONObject("result").getString("pages"));
                int pageDiscardIncomeExpenseTotal=Integer.parseInt(pageDiscardIncomeExpenseResult.getJSONObject("result").getString("total"));


                for(int k=0; k == pageDiscardIncomeExpensePages+1; k++){
                    int n =k==pageDiscardIncomeExpensePages ? (pageDiscardIncomeExpenseTotal%10==0 ? 10 : pageDiscardIncomeExpenseTotal%10) : 10;
                    JSONArray records=pageDiscardIncomeExpenseResult.getJSONObject("result").getJSONArray("records");
                    boolean flag=true;
                    for(int i=0; i<n; i++){
                        String pageDiscardIncomeExpenseId=records.getJSONObject(i).getString("id");
                        if(pageDiscardIncomeExpenseId.equals(listByVoucherId)){
                            flag = true;
                            break;
                        }
                    }
                    Assert.assertEquals(true,flag,"签单订单的收支明细未被作废");
                }

                //获取已作废收支详情
                JSONObject getResult=revenueAndExpenditureTools.get(listByVoucherId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId());
                String getBusinessNo=getResult.getJSONObject("result").getString("businessNo");
                String getState=getResult.getJSONObject("result").getString("state");

                Assert.assertEquals(getBusinessNo.equals(businessNo),true,"签单订单的收支明细未被作废");
                Assert.assertEquals(getState,"DISCARD","签单订单的收支明细未被作废");


            }
            else {
                Assert.assertEquals(checkDiscardVoucherResult, false, "签单订单不能作废");

            }

        }

        }

}
