package com.xiaomai.cases.polar.finance.revenueAndExpenditure;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.util.Date;

public class RevenueAndExpenditureTools extends XMBaseTest {

    /**
     * @param
     * @description:分页收支列表
     * @param paymentWays：支付方式  1  2
     * @param type:	业务收支类型：INCOME:收入 EXPENSE:支出
     * @param item:	业务收支类型：SIGN:签单 REFUND:退单
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageNormalIncomeExpense(String paymentWays, String type, String item, String supplierId, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageNormalIncomeExpense")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add(paymentWays);
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:统计收支
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject sumNormalIncomeExpense(String paymentWays, String type, String item,String supplierId, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumNormalIncomeExpense")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add(paymentWays);
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:分页作废收支列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageDiscardIncomeExpense(String paymentWays, String type, String item, String supplierId, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageDiscardIncomeExpense")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);


        JSONArray jsonArray=new JSONArray();
        jsonArray.add(paymentWays);
        jsonObject.put("paymentWays",jsonArray);

        jsonObject.put("type",type);
        jsonObject.put("item",item);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取收支的支付/退款记录
     * @param id：主键ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject get(String id, String brandId, String studioId, String operatorId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_get")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

}
