package com.xiaomai.cases.polar.setting.courseCategory;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.courseCategory
 * @Author: xuyamei
 * @CreateTime: 2024-04-29  09:08
 * @Description:创建课程分类
 * @Version: 1.0
 */
public class TestCreateCourseCategory extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;

    private String categoryId;
    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_courseCategory_getDetailPage", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test(description = "查询要创建的名称是否存在-->不存在则新建-->查询新建之后的数据是否存在")
    public void testCourseCategoryGetDetailPage(){
        // 查询课程分类是否超过50个上限
        JSONObject detailPage = courseCategoryTools.getCourseCategoryDetailPage(0);
        if (detailPage.getJSONObject("result").getInteger("total").equals("50"))
            return;
        String courseCategoryName = "课程分类名称"+ TimeUtils.getCurrentTime();
        // 验证课程名称是否重复，不重复则新建
        if(courseCategoryTools.checkCategoryNameDup(courseCategoryName,""))
            return;
        //创建课程分类
        categoryId = courseCategoryTools.createCourseCategory(courseCategoryName);
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取课程分类详情
        detailPage = courseCategoryTools.getCourseCategoryDetailPage(0);
        String operatorId = detailPage.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("lastOperatorId");  // 最后操作人
        String courseCategoryId = detailPage.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id"); // 课程分类id
        String categoryName = detailPage.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("categoryName"); // 课程分类名称
        Assert.assertEquals(operatorId.equals(xmAppApi.getLoginInfo().getAdminId()) && courseCategoryId.equals(categoryId) && categoryName.equals(courseCategoryName),true,"新建的课程分类与查询的不一致");

    }

    @Test(description = "清除增量数据",priority = 1)
    public void del(){
        boolean flag = courseCategoryTools.canModifyCourseCategory(categoryId,true);
        if (flag){
            courseCategoryTools.deleteCourseCategory(categoryId);

        }
    }
}
