package com.xiaomai.cases.polar.brandMerchant;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-23  11:48
 * @Description: 获取最新商户号
 * @Version: 1.0
 */
public class TestGetLatestApply extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Merchant)
                .setApiName("API_getLatestApply")
                .setLoginUser(LoginAccount.XYY_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取最新商户号")
    public void testBrandMerchantList(){

        JSONObject object = new JSONObject();
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());

        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
    }
}