package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestGetById extends XMBaseTest {

    CashierTools cashierTools=new CashierTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_getById")
                .setLoginUser(LoginAccount.YFF_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "查询收银流水详情")
    public void testGetById(){

        //10020060066--固定流水，换场馆需要按照这个手机支付0.01元 "flowIds": ["1808757176611880962"]
        JSONObject page_select=cashierTools.page_select(null,"10020060066",null);
        String id=page_select.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");//流水ID

        JSONObject getById=new JSONObject();
        getById.put("id",id);
        getById.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        getById.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        getById.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,getById.toJSONString(),headers).assetsSuccess(true);
        String success=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(success,"true","查询收银流水详情失败");


    }


}
