package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 编辑当前课次/编辑当前及后续课次
 * @author adu
 * data 2024/7/2 10:45
 */

public class TestEditGroupSchedule extends UniversalDataScheduling {
    public static Date now = new Date();
    Set<String> scheduleIdsN;


    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_editGroupSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "编辑当前课次")
    public void testEditCurrentSchedule() {
        //获取下周四的课次ID
        scheduleIdsN = groupScheduleTools.getTableDate(10);
        //如果课次ID有值则继续走删除的case
        if (!scheduleIdsN.isEmpty()) {
            scheduleIdsN.stream().forEach(scheduleId -> {
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("applyRestRule", false);
                body.put("scheduleId", scheduleId);
                //获取下周四某个时间点的开始时间戳
                String startStamp = getWholeHourTimeStamp(10,"13:30");
                body.put("startTime", startStamp);

                body.put("chiefCoachId", chiefCoachIdS);
                body.put("minMemberNum", 1);
                body.put("maxMemberNum", 10);
                body.put("venueAreaIds", new ArrayList<>());
                body.put("assistCoachIds", new ArrayList<>());
                body.put("spanMinutes", 50);
                body.put("force", true);//有冲突时忽略冲突
                body.put("retainBooking", false);//不保留学员预约

                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                //编辑成功后check对应课次详情修改内容是否同步成功
                groupScheduleTools.getScheduleItemDetail(scheduleId);
                String detailResult = dataApi.getApi_response();
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.chiefCoachId"), chiefCoachIdS);
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.minMemberNum"), "1");
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.maxMemberNum"), "10");
                Assert.assertEquals(XMJSONPath.readPath(detailResult, "$.result.startTime"), startStamp);
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.assistCoachIds").size() == 0, "助教修改后（置空）没生效");
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult, "$.result.venueAreaIds").size() == 0, "场地修改后（置空）没生效");


            });
        }

    }

    @Test(description = "编辑当前及后续课次", priority = 1)
    public void testEditCurrentAndSubsequentSchedule() {
        //获取下周二的课次ID
        Set<String> scheduleIds = groupScheduleTools.getTableDate(8);
        //如果课次ID有值则继续走编辑的case
        if (!scheduleIds.isEmpty()) {
            scheduleIds.stream().forEach(scheduleId -> {
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("applyRestRule", true);//改的时日程当前及后续
                body.put("scheduleId", scheduleId);
                //获取下周二某个时间点的开始时间戳
                String startStamp1 =getWholeHourTimeStamp(8,"13:00");
                body.put("startTime", startStamp1);

                body.put("chiefCoachId", chiefCoachIdS);
                body.put("minMemberNum", 6);//修改开课人数
                body.put("maxMemberNum", 999);
                body.put("venueAreaIds", venueAreaIds);
                body.put("assistCoachIds", new ArrayList<>());//修改教练
                body.put("spanMinutes", 50);
                body.put("force", true);//有冲突时忽略冲突
                //body.put("retainBooking", true);//保留学员预约，无改动到时间，教练，场地则不需要传此字段

                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                //编辑成功后check对应课次详情修改内容是否同步成功
                checkData(scheduleId,startStamp1);

                //查看下周三课次是否同步被修改
                Set<String> scheduleIdX = groupScheduleTools.getTableDate(9);
                String startStamp2 = getWholeHourTimeStamp(9,"13:00");
                if (!scheduleIdX.isEmpty()) {
                    scheduleIdX.stream().forEach(scheduleId1 -> {
                        //编辑成功后check同规则中下周三课次详情修改内容是否同步成功
                        checkData(scheduleId1,startStamp2);
                    });
                }


            });
        }
        //获取下周一的课次ID，查看下周一课次是否还是原来的（没被修改，还是原来的规则）
        Set<String> scheduleId1 = groupScheduleTools.getTableDate(7);
        String startStamp3=getWholeHourTimeStamp(7,"13:00");
        if (!scheduleId1.isEmpty()) {
            scheduleId1.stream().forEach(scheduleId0 -> {
                //编辑成功后check同规则中下周一课次详情
                groupScheduleTools.getScheduleItemDetail(scheduleId0);
                String detailResult1 = dataApi.getApi_response();
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.chiefCoachId"), chiefCoachIdS);
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.minMemberNum"), "2");
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.maxMemberNum"), "999");
                Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.startTime"), startStamp3);
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.assistCoachIds").containsAll(assistCoachIdS), "助教无修改，但是却变动了");
                Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.venueAreaIds").containsAll(venueAreaIds), "场地无修改，但是却变动了");


            });
        }




    }

    /**
     *
     * @param n 整数
     * @param time 整点时间 比如13：00
     * @return
     */
    public String getWholeHourTimeStamp(int n,String time){
        Date getWeekStartDayData = CommUtil.getStartOfDateWeek(now);
        Date getNextWeekXDayData = CommUtil.addNDays(getWeekStartDayData, n);
        String getNextWeekXDayDataS = new SimpleDateFormat("yyyy-MM-dd").format(getNextWeekXDayData.getTime());
        return CommUtil.getStringTimestampByStrTime(getNextWeekXDayDataS + " " + time);

    }

    /**
     * 编辑后通过查看课次详情check数据是否同步被修改
     * @param scheduleId
     */
    public void checkData(String scheduleId,String tiemStamp){
            groupScheduleTools.getScheduleItemDetail(scheduleId);
            String detailResult1 = dataApi.getApi_response();
            Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.chiefCoachId"), chiefCoachIdS);
            Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.minMemberNum"), "6");
            Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.maxMemberNum"), "999");
            Assert.assertEquals(XMJSONPath.readPath(detailResult1, "$.result.startTime"), tiemStamp);
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.assistCoachIds").size() == 0, "助教修改后（置空）没生效");
            Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(detailResult1, "$.result.venueAreaIds").containsAll(venueAreaIds), "场地无修改，但是却变动了");

        }



    @AfterClass(description = "删除此case创建的日程")
    public void delData(){
        List<String> ruleIdIds = new ArrayList<>();
        //查询这个case创建的相关日程
        JSONArray result = groupScheduleTools.getGroupRuleScheduleList(courseId, chiefCoachIdS);
        int count = result.size();
        if (count > 0) {//如果有数据，则获取对应日程ID
            ruleIdIds = result.stream().map(obj -> {
                        JSONObject ruldIdInfo = (JSONObject) obj;
                        return ruldIdInfo.getString("ruleId");
                    }
            ).collect(Collectors.toList());
        }
        if (ruleIdIds != null) {//获取到的日程ID不为空时，则逐个删除相关日程
            ruleIdIds.stream().forEach(ruleId -> {
                //删除对应日程
                groupScheduleTools.delGroupRuleSchedule(ruleId, true);

            });
        }

        if (!scheduleIdsN.isEmpty()) {
            scheduleIdsN.stream().forEach(scheduleId -> {
                //删除case1中编辑独立出去的课次
                 groupScheduleTools.delGroupScheduleItem(scheduleId);
            });
        }


    }

}


    