package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestGetTrainingPlanContent extends BaseTestImpl {

    @Resource(name="trainingTools")
    TrainingTools trainingTools;
    @Resource(name="userTools")
    UserTools userTools;
    DataUserInfo info = new DataUserInfo();
    String memberId;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Training, "API_getTrainingPlanContent", LoginAccount.GYM_PROD, Terminal.B, "xyy");
        super.beforeTest();
    }

    @Test(description = "智能生成训练计划>查看训练详情>编辑训练计划>C端查看动作详情>删除训练计划")
    public void testGetTrainingPlanContent() throws InterruptedException {
        info.setTerminal(Terminal.minApp);
        info.setLoginUser(LoginAccount.GYM_MINIAPPC);
        //1.获取会员id
        memberId = userTools.getMemberInfo(info).getString("memberId");

        //2.获取胸部id
        String bodyPartId = XMJSONPath.readPath(trainingTools.getBodyPartList(),"$.result[0].id");

        //3.获取b端训练计划列表数据条数
        int num = Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"));

        //4.智能生成中
        String generateId = trainingTools.generateTrainingPlan(bodyPartId,memberId);

        JSONObject body = new JSONObject();
        body.put("id",generateId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        Thread.sleep(2000);
        Assert.assertNotNull(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result"));

        //5.保存并发送训练计划
        String exerciseId = XMJSONPath.readPath(trainingTools.getListByName("上斜绳索夹胸"),"$.result[0].id");
        String exerciseName = XMJSONPath.readPath(trainingTools.getListByName("上斜绳索夹胸"),"$.result[0].name");
        String recordId = trainingTools.trainingPlanRecordCreate(memberId,exerciseId,exerciseName);
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"))==num+1);

        //查看c端动作详情信息与b端提交的数据匹配
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.findTrainExerciseDetailById(exerciseId,recordId,info),"$.result.name"),exerciseName);
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.findTrainExerciseDetailById(exerciseId,recordId,info),"$.result.trainingBodyPartList[0].id"),bodyPartId);

        //6.清理数据
        //删除训练计划
        trainingTools.trainingPlanRecordDelete(recordId);
        //检验训练计划列表数据跟初始保持一致
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingPlanRecordPage(memberId,""),"$.result.total"))==num);
    }
}
