package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 创建训练营排课
 *
 * @author adu
 * data 2024/7/9 14:49
 */

public class TestCreateCampRuleSchedule extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;

    String ruldId="";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_createCampRuleSchedule", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "创建训练营排课日程")
    public void testCreateCampRuleSchedule() {
        System.out.println("*********************" + campInfo);
        //从训练营活动中获取教练信息
        String chiefCoachId = campInfo.get(0).getJSONArray("trainerList").toJavaList(JSONObject.class).stream().filter(e -> {
            return "杜君丽".equals(e.getString("nickName"));
        }).map(e -> e.getString("id")).findFirst().orElse(null);
        System.out.println(id);

        //从训练营活动中获取助教信息
        List<String> assistCoachIds = campInfo.get(0).getJSONArray("trainerList").toJavaList(JSONObject.class).stream().filter(e -> {
            return !"杜君丽".equals(e.getString("nickName"));
        }).map(e -> e.getString("id")).collect(Collectors.toList());

        //获取存量场地
        List<String> venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        String campId=campInfo.get(0).getString("id");
        //创建训练营排课
        campScheduleTools.createCampRuleSchedule(campId, assistCoachIds, chiefCoachId, campInfo.get(0).getString("courseId"),
                campInfo.get(0).getIntValue("traineeLowerLimit"), campInfo.get(0).getIntValue("traineeUpperLimit"),
                "1020", campInfo.get(0).getString("openStartDate"), campInfo.get(0).getString("openEndDate"), true,
                venueAreaIds, "");

        //查询排课日程:根据训练营和教练（其中一个助教）查询
        campScheduleTools.getCampRuleScheduleList(campId,null,assistCoachIds.get(0).toString());
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size()==1,"排课创建成功后，日程中没查询到对应数据");
        ruldId=XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").getJSONObject(0).getString("ruleId");
    }

    @AfterClass(description = "删除此case创建的训练营排课日程")
    public void delData() {
        if (null!=ruldId||!ruldId.isEmpty()) {
            campScheduleTools.delCampRuleSchedule(ruldId);
        }

    }


}