package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 训练营排课相关工具类
 * @author adu
 * data 2024/7/9 10:19
 */
@Component("campScheduleTools")
public class CampScheduleTools extends XMBaseTest {

    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Polar_Schedule)
                .setApiName(apiName)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfo);
    }

    /**
     * 创建训练营排课
     * @param campId 训练营活动ID
     * @param assistCoachIds 助教ID
     * @param chiefCoachId 教练ID
     * @param courseId 课程ID 这个值直接从选择的训练营活动中获取
     * @param minMemberNum 开课人数 这个值直接从选择的训练营活动中获取
     * @param maxMemberNum 人数上线 这个值直接从选择的训练营活动中获取
     * @param minuteOffset 上课开始时间 整点*60 获取这个值 24小时制
     * @param startDate 开课开始时间，这个值要大于等于训练营的开营时间
     * @param endDate 开课结束时间，这个值要小于等于训练营的结束时间
     * @param force 排课是否冲突，有冲突时true，无冲突时传false
     * @param venueAreaIds 场地ID
     * @param maxLoop  上课次数，按次数时要传这个值；如果设置按日期 则传""；
     * @param userInfo
     */
    public void createCampRuleSchedule(String campId, List<String> assistCoachIds,String chiefCoachId,String courseId,
                                       int minMemberNum,int maxMemberNum,String minuteOffset,String startDate,String endDate,
                                       Boolean force,List<String> venueAreaIds,String maxLoop,DataUserInfo... userInfo){
        setUP("API_createCampRuleSchedule", userInfo);
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        if(null!=maxLoop||!maxLoop.isEmpty()){
            body.put("maxLoop", maxLoop);
        }
        body.put("campId", campId);
        body.put("courseId", courseId);
        body.put("chiefCoachId", chiefCoachId);
        body.put("minMemberNum", minMemberNum); // 开课人数
        body.put("maxMemberNum", maxMemberNum); //人数上限
        body.put("minuteOffset", minuteOffset); //上课开始时间
        body.put("startDate", startDate); //排课开始日期
        body.put("endDate", endDate); //排课结束日期
        String[] weekDaysArray = {"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};
        List<String> weekdaysList = Arrays.asList(weekDaysArray);
        body.put("weekdays", weekdaysList); //设置上课星期，目前是每天都会选择
        body.put("venueAreaIds", venueAreaIds); //场地，可设置为空 new ArrayList<>();
        body.put("assistCoachIds", assistCoachIds); //设置助教，可设置为空 new ArrayList<>();
        body.put("force", force); //是否有冲突 true，false
        body.put("enableCustomerReserve", "NO"); //能否用户自己约课，不能
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
    }

    /**
     * 快速创建排课，周二，周四，周六，周日
     * @param campId
     * @param chiefCoachId
     * @param courseId
     * @param minMemberNum
     * @param maxMemberNum
     * @param minuteOffset
     * @param endDate
     * @param force
     * @param maxLoop
     */
    public void oneKeyCreateCampRuleSchedule(String campId,String chiefCoachId,String courseId,
                                             int minMemberNum,int maxMemberNum,String minuteOffset,String endDate,
                                             Boolean force,String maxLoop){
        setUP("API_createCampRuleSchedule");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        if(null!=maxLoop||!maxLoop.isEmpty()){
            body.put("maxLoop", maxLoop);
        }
        body.put("campId", campId);
        body.put("courseId", courseId);
        body.put("chiefCoachId", chiefCoachId);
        body.put("minMemberNum", minMemberNum); // 开课人数
        body.put("maxMemberNum", maxMemberNum); //人数上限
        body.put("minuteOffset", minuteOffset); //上课开始时间
        body.put("startDate", CommUtil.oneKeyGetAddDay(3));//大后天，晚于开营时间1天
        body.put("endDate", endDate); //排课结束日期,取训练营结束日期
        String[] weekDaysArray = { "TUESDAY", "THURSDAY", "SATURDAY", "SUNDAY"};
        List<String> weekdaysList = Arrays.asList(weekDaysArray);
        body.put("weekdays", weekdaysList); //设置上课星期，目前是每天都会选择
        body.put("venueAreaIds", new ArrayList<>()); //场地，可设置为空 new ArrayList<>();
        body.put("assistCoachIds", new ArrayList<>()); //设置助教，可设置为空 new ArrayList<>();
        body.put("force", force); //是否有冲突 true，false
        body.put("enableCustomerReserve", "NO"); //能否用户自己约课，不能
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);

    }

    /**
     * 查看训练营排课日程
     * @param campId 根据训练营活动查询 ，传值时有筛选条件，""时不传该值，看了前端传值一般没筛选条件时不传，只要有一个筛选条件，其他筛选条件要传null
     * @param courseId 根据课程查询
     * @param coachId 根据教练查询
     * @param userInfo
     */
    public void getCampRuleScheduleList(String campId,String courseId,String coachId,DataUserInfo... userInfo){
        setUP("API_getCampRuleScheduleList", userInfo);
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("coachId", coachId);
        body.put("courseId", courseId);
        body.put("campId", campId);
       /* if(null!= campId && !campId.isEmpty()){
            body.put("campId", campId);
        }
        if(null!=courseId||!courseId.isEmpty()){
            body.put("courseId", courseId);

        }
        if(null!=coachId||!coachId.isEmpty()){
            body.put("coachId", coachId);
        }*/

        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);

    }

    /**
     * 删除训练营排课日程
     * @param ruleId 日程对应的规则ID
     */
    public void delCampRuleSchedule(String ruleId){
        setUP("API_delCampRuleSchedule");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("force", true);//删除学员约课记录
        body.put("ruleId", ruleId);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);

    }

    /**
     * 查看训练营排课课表
     * @param startDate 开始日期，如果查看的是日课表，传当前的开始日期00；如果是周课表，传的是指定周的周一开始日期
     * @param endDate 结束日期 ，如果查看的是日课表，传当前的结束日期23：59：59；如果是周课表，传的是指定周的周日结束日期
     * @return
     */
    public JSONArray getCampScheduleTable(String startDate, String endDate) {
        setUP("API_getCampScheduleTable");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("startDate", startDate);
        body.put("endDate", endDate);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        if (Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.totalCount")) > 0) {
            return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("timetableGroups").getJSONObject(0).getJSONArray("timetableList");
        }
        else {
            return null;
        }
    }

    /**
     * 根据时间和星期查询有效循环次数
     * @param startDate
     * @param endDate
     * @param weekdaysList
     * @return
     */
    public int queryExpectedLoopNum(String startDate, String endDate,List<String> weekdaysList){
        setUP("API_queryExpectedLoopNum");
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        body.put("startDate", startDate);
        body.put("endDate", endDate);
        body.put("weekdays", weekdaysList);
        dataApi.doRequest(RequestType.JSON, dataparams, body.toString(), dataheadrs).assetsSuccess(true);
        return Integer.valueOf(XMJSONPath.readPath(dataApi.getApi_response(),"$.result"));


    }

}

    