package com.xiaomai.cases.polar.schedule.camp;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 测试获取训练营排课课表
 *
 * @author adu
 * data 2024/7/10 10:11
 */

public class TestGetCampScheduleTable extends SelectTargetTrainingCampAndGetInfo {
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "campScheduleTools")
    CampScheduleTools campScheduleTools;
    List<String> venueAreaIds;
    String venueAreaId = "";
    String campId = "";
    String chiefCoachId = "";
    String ruldId="";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_getCampScheduleTable", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
        venueAreaIds = groupScheduleTools.getStockArea("流星花园秘密基地");
        venueAreaId = venueAreaIds.get(0).toString();
        campId = super.campId;
        chiefCoachId = super.chiefCoachId;
        //从训练营活动中获取助教信息
        List<String> assistCoachIds = super.assistCoachIds;

        //创建训练营排课：按次数
        campScheduleTools.createCampRuleSchedule(campId, assistCoachIds, chiefCoachId, super.courseId,
                super.traineeLowerLimit,super.traineeUpperLimit,
                "1020",super.openStartDate, super.openEndDate, true,
                venueAreaIds, "20");

        //查询排课日程:根据训练营和教练,关联课程查询
        campScheduleTools.getCampRuleScheduleList(campId,super.courseId,chiefCoachId);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size()==1,"排课创建成功后，日程中没查询到对应数据");
        ruldId=XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").getJSONObject(0).getString("ruleId");
    }

    @DataProvider(name = "filterCampScheduleTableDateByCondition")
    public Object[][] dataProvider() {
        //组装已上课课次状态
        List<String> doneStatus = new ArrayList<>();
        doneStatus.add("IN_PROGRESS");
        doneStatus.add("DONE");
        //组装待上课课次状态
        List<String> todoStatus = new ArrayList<>();
        todoStatus.add("TODO");

        return new Object[][]{
                {"", "", new ArrayList<>(), "", 1},//无筛选条件
                {campId, "", new ArrayList<>(), "", 1},//根据训练营搜索
                {campId, chiefCoachId, new ArrayList<>(), "", 1},//根据训练营和主教练
                {campId, chiefCoachId, todoStatus, "", 1},//根据训练营，教练，待上课
                {campId, chiefCoachId, todoStatus, venueAreaId, 1},//根据训练营，教练，待上课，场地
                {campId, chiefCoachId, doneStatus, "", 0},//根据训练营，教练，已上课
                {"", "", todoStatus, "", 1},//根据课次状态：待上课
                {"", "", doneStatus, "", 0},//根据课次状态已上课["IN_PROGRESS", "DONE"]
                {campId, "", todoStatus, "", 1},//根据训练营名称和课次待上课
                {campId, "", doneStatus, "", 0},//根据训练营名称和课次已上课
                {"", chiefCoachId, new ArrayList<>(), "", 1},//根据主教练
                {"", chiefCoachId, todoStatus, "", 1},//教练和上课状态待上课
                {"", chiefCoachId, doneStatus, "", 0},//教练和上课状态已上课
                {"", "", new ArrayList<>(), venueAreaId, 1},// 场地
                {campId, "", new ArrayList<>(), venueAreaId, 1},// 场地和训练营名称
                {"", chiefCoachId, new ArrayList<>(), venueAreaId, 1},// 场地和教练
                {"", "", todoStatus, venueAreaId, 1},// 场地和待上课课次
                {"", "", doneStatus, venueAreaId, 0},// 场地和已上课课次
                {campId, chiefCoachId, new ArrayList<>(), venueAreaId, 1},// 场地，训练营，教练


        };
    }

    @Test(description = "查看训练营课表", dataProvider = "filterCampScheduleTableDateByCondition")
    public void testGetCampScheduleTable(String campId, String coachId, List<String> statusSet, String venueAreaId, int total) {
        JSONObject body = new JSONObject();
        body.put("operatorId", dataApi.getLoginInfo().getAdminId());
        body.put("studioId", dataApi.getLoginInfo().getStudioId());
        body.put("brandId", dataApi.getLoginInfo().getBrandId());
        //下周课表
        body.put("startDate", CommUtil.oneKeyGetNextWeekStartDay());
        body.put("endDate", CommUtil.oneKeyGetNextWeekEndDay());
        body.put("campId", campId);
        body.put("coachId", coachId);
        body.put("statusSet", statusSet);
        body.put("venueAreaId", venueAreaId);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        int resultCount = Integer.parseInt(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.result.totalCount"));
        Assert.assertTrue(resultCount >= total, "查询到的课表数据和预期不一致");
    }

    @AfterClass(description = "删除此case创建的训练营排课日程")
    public void delData() {
        if (null!=ruldId||!ruldId.isEmpty()) {
            campScheduleTools.delCampRuleSchedule(ruldId);
        }

    }


}

    