package com.xiaomai.cases.lunar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.training
 * @Author: xuyamei
 * @CreateTime: 2024-07-31  14:48
 * @Description: 训练营相关接口
 * @Version: 1.0
 */
@Component("trainingCTools")
public class TrainingCTools extends BaseTestImpl {
    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Lunar_Training)
                .setApiName(apiName)
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfo);
    }


    /**
     * @description: 查询在售训练营
     * @author: xuyamei
     * @date:  2024/7/31 16:55
     * @param title：训练营名称
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray getAppliableCampList(String title) {
        setUP("API_fetchAppliableCampList");

        JSONObject body = new JSONObject();
        body.put("current",0);
        body.put("size",10);
        body.put("title",title);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result").getJSONArray("records");
    }


    /**
     * @description:查询训练营详情
     * @author: xuyamei
     * @date:  2024/7/31 16:55
     * @param trainingCampId 训练营活动id
     * @param memberId 会员id
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject findDetailById(String trainingCampId,String memberId) {
        setUP("API_findDetailById");

        JSONObject body = new JSONObject();
        body.put("trainingCampId",trainingCampId);
        body.put("memberId",memberId);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * @description:我的训练营列表
     * @author: xuyamei
     * @date:  2024/7/31 16:56
     * @param memberId 会员id
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONArray listMyTrainingCamp(String memberId) {
        setUP("API_listMyTrainingCamp");

        JSONObject body = new JSONObject();
        body.put("memberId",memberId);
        body.put("usable",true);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }

    /**
     * @description:获取我的训练营详情
     * @author: xuyamei
     * @date:  2024/7/31 17:06
     * @param id
     * @return: com.alibaba.fastjson.JSONArray
     **/
    public JSONObject findMyTrainingCampDetailById(String id) {
        setUP("API_findMyTrainingCampDetailById");

        JSONObject body = new JSONObject();
        body.put("id",id);
        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    public JSONArray getMemberCampScheduleItemList(Long startDate, Long endDate, String memberId){
        setUP("API_getMemberCampScheduleItemList");

        JSONObject body = new JSONObject();
        body.put("startDate",startDate);
        body.put("endDate",endDate);
        body.put("memberId",memberId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON,dataparams,body.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONArray("result");
    }





}
