package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-06  16:33
 * @Description: 剩余份数小于设置的预警值合同管理提示条
 * @Version: 1.0
 */
public class TestGetShowResidueCount extends BaseTestImpl {
    @Resource(name = "eleContractTools")
    EleContractTools eleContractTools;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getShowResidueCount", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetShowResidueCount(){
        int warning = 1000;
        // 查询预警记录id
        JSONObject balanceWarning = eleContractTools.getBalanceWarning();
        String id = balanceWarning.getString("id");
        // 先设置预警值
        eleContractTools.setBalanceWarning(warning, id);
        // 查询剩余份数小于设置的预警值合同管理提示条
        JSONObject body = new JSONObject();
        body.put("tenantId",xmAppApi.getLoginInfo().getStudioId());
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        body.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        Assert.assertTrue(xmAppApi.getBodyInJSON().getInteger("result") == warning);
    }

}
