package com.xiaomai.cases.polar.experienceCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/13 09:48
 */
public class TestCreateExperienceCard extends XMBaseTest {
    Tools tools = new Tools();
    CardTools cardTools = new CardTools();
    String id;
    String title;
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_create")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "创建体验卡")
    public void testCreateExperienceCard() {
        Random random = new Random();

        String[] benefit_all = {"课程次数入场次数","课程期限入场期限","课程次数入场期限","课程期限入场次数","课程期限","课程次数","入场期限","入场次数"};//权益
        String benefit = benefit_all[random.nextInt(8)];

        for(int i=0;i<3;i++){
            title = benefit+ RandomStringUtil.randomString(3)+"-自动化创建";
            //check是否存在同名的体验卡，不存在则新建
            Boolean duplicate = tools.checkTitleDuplicate(title, "EXPERIENCE_CARD").getBoolean("result");
            if (duplicate == false) {
                id = tools.create("EXPERIENCE_CARD",title,"全部","YES",benefit).getString("result");
                break;
            }
        }

        //新建后校验体验卡第一条数据是新建的那条数据
        String id1 = tools.fetchPageOfMemberCard("EXPERIENCE_CARD","","","","").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        Assert.assertEquals(id,id1);

        //停用体验卡
        cardTools.modifyMemberCardShelfState(id,"NO");
        Assert.assertEquals(cardTools.fetchDetailById(id).getJSONObject("result").getString("shelfState"),"NO");

        //启用体验卡
        cardTools.modifyMemberCardShelfState(id,"YES");
        Assert.assertEquals(cardTools.fetchDetailById(id).getJSONObject("result").getString("shelfState"),"YES");

        //关闭小程序售卖
        cardTools.modifyXcxSaleState(id,"NO");
        Assert.assertEquals(cardTools.fetchDetailById(id).getJSONObject("result").getString("xcxSaleStatus"),"NO");

        //开启小程序售卖
        cardTools.modifyXcxSaleState(id,"YES");
        Assert.assertEquals(cardTools.fetchDetailById(id).getJSONObject("result").getString("xcxSaleStatus"),"YES");



    }
}
