package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDiscardManualDeduct extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_discardManualDeduct")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "撤销手动扣次")
    public void testDiscardManualDeduct() {
        CardTools Cardtools = new CardTools();
        Cardtools.membercardsearch("NORMAL");
        String benefitId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].courseBenefit.id");
        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张会员卡的ID;



        Cardtools.manualDeduct(benefitId,memberCardId);//手动扣次
        Cardtools.fetchPageOfConsumeRecord(benefitId,memberCardId);
        String consumeRecordId=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("consumeRecordId",consumeRecordId);
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
}
