package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

public class TestTenantMemberCard_update extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_update")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "编辑会员卡")
    public void testmodifySharers() {
        CardTools Cardtools = new CardTools();
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Cardtools.memberCardCreate("次卡-自动化会员卡"+ RandomStringUtil.randomString(3));//创建随机的名的次卡
        Cardtools.fetchPageOfMemberCard("MEMBER_CARD");

        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");


        JSONArray activatePatternList=new JSONArray();
        activatePatternList.add("PURCHASE");
        activatePatternList.add("SPECIFIC_DATE");
        activatePatternList.add("FIRST_USED");

        List benefitList = new ArrayList();
        //List itemList = new ArrayList();
        //itemList.add("");
        JSONObject Object = new JSONObject();
        Object.put("identifier", xmAppApi.getLoginInfo().getUser());
        Object.put("benefitType", "BALANCE");
        Object.put("targetScope", "GROUP_CLASS_AND_PERSONAL_COURSE");
        Object.put("balance", "30");
        Object.put("reserveLimitType", "UN_LIMIT");
        Object.put("reserveLimitNumber", 0);
        Object.put("defaultConsumeBalance", 1);
        //Object.put("itemList", itemList);
        Object.put("targetType", "COURSE");
        Object.put("price","1");

        benefitList.add(Object);





        JSONObject jsonObject = new JSONObject();
        jsonObject.put("surfaceUrl","https://image.xiaomaiketang.com/xm/internal/HpRiJpFnTC.png");//会员卡封面图片
        jsonObject.put("surfaceCornerMark","自动化标签");
        jsonObject.put("title","" );//编辑无法修改会员卡名称
        jsonObject.put("validPeriod", "3");//有效期-3天
        jsonObject.put("activatePatternList", activatePatternList);//三种生效方式
        jsonObject.put("sharePeopleLimit", "2");//共享人数
        jsonObject.put("benefitList", benefitList);//使用权益
        jsonObject.put("price", "1");//价格
        jsonObject.put("underlinePrice", "10");//划线价
        jsonObject.put("purchaseNumberLimit", "-1");//购买数量限制
        jsonObject.put("xcxSaleStatus", "YES");//小程序是否售卖
        jsonObject.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("shelfState", "YES");//卡启用状态
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("description", "{\"items\":[{\"content\":\"自动化编辑的卡\",\"aspect\":\"\",\"type\":\"TEXT\"}]}");
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("commodityCardType","MEMBER_CARD");


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
}
