package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

public class CashierTools extends XMBaseTest {

    /**
     * @param
     * @description: 分页筛选收银流水-搜索
     * @param buyerName:支付姓名 不用需要传null
     * @param buyerPhone：支付手机号 不用需要传null
     * @param businessNo：支付订单号 不用需要传null
     * @author: yangfangfang
     **/
    public JSONObject page_select(String buyerName, String buyerPhone, String businessNo, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_page")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("buyerName",buyerName);
        jsonObject.put("buyerPhone",buyerPhone);
        jsonObject.put("businessNo",businessNo);
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description: 分页筛选收银流水-筛选
     * @param subChannel:支付方式 [ "支付宝", "微信" ] [ ALI, WX ]
     * @param orderType：来源[ "未知", "签单", "退单", "作废订单", "收款码", "B端短信充值", "电子合同" ][ UNKNOWN, SIGN_ORDER, REFUND_ORDER, DISCARD_ORDER, PAY_QR_CODE, B_SMS_RECHARGE, ELE_CONTRACT ]
     * @author: yangfangfang
     **/
    public JSONObject page_sift(String subChannel, String orderType, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_page")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("subChannel",subChannel);//支付方式 [ "支付宝", "微信" ] [ ALI, WX ]

        JSONArray transStateList=new JSONArray();//收款成功（入账中、入账成功）,这两个状态都代表收款成功
        transStateList.add("PAY_SUCCESS");
        transStateList.add("PAY_IN");
        jsonObject.put("transStateList",transStateList);

        jsonObject.put("orderType",orderType);//来源[ "未知", "签单", "退单", "作废订单", "收款码", "B端短信充值", "电子合同" ][ UNKNOWN, SIGN_ORDER, REFUND_ORDER, DISCARD_ORDER, PAY_QR_CODE, B_SMS_RECHARGE, ELE_CONTRACT ]

        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


}
