package com.xiaomai.cases.polar.setting.venue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.venue
 * @Author: xuyamei
 * @CreateTime: 2024-05-08  11:25
 * @Description: 创建场地
 * @Version: 1.0
 */
public class TestCreateVenueArea extends BaseTestImpl {
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;
    @BeforeClass
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_createVenueArea", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    private String groupId;
    @Test
    public void testCreateVenueArea() {
        String name = "瑜伽场地" + System.currentTimeMillis();
        groupId = venueAreaTools.createVenueArea(name);
        try {
            Thread.sleep(500);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // check：新建之后查询列表数据
        JSONObject response = venueAreaTools.getVenueAreaPage();
        String id = response.getJSONArray("records").getJSONObject(0).getString("groupId");
        String groupName = response.getJSONArray("records").getJSONObject(0).getString("groupName");
        Assert.assertEquals(id.equals(groupId) && groupName.equals(name) , true,"新建之后查询到的数据与新建不一致");
    }

    @Test(description = "清除增量数据",priority = 1)
    public void del() {
        venueAreaTools.deleteVenueArea(groupId);
    }
}
