package com.xiaomai.cases.polar.setting.venue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestSaveVenueAreaBookingRules extends XMBaseTest {
    @Resource(name = "venueAreaTools")
    VenueAreaTools venueAreaTools;

    public String ruleId;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_saveVenueAreaBookingRules")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();

        ruleId = venueAreaTools.getVenueAreaBookingRules();

    }
    @Test(description = "场地预约规则全部开关开启")
    public void testSaveVenueAreaBookingRules_on(){

        JSONObject bookingStartRuleRequest = new JSONObject();
        bookingStartRuleRequest.put("bookingStartComingDays","7");
        bookingStartRuleRequest.put("limit",true);

        JSONObject bookingEndRuleRequest = new JSONObject();
        bookingEndRuleRequest.put("bookingEndBeforeMinutes","60");
        bookingEndRuleRequest.put("bookingEndBeforeUnit","hour");
        bookingEndRuleRequest.put("limit",true);

        JSONObject cancelBookingRuleRequest = new JSONObject();
        cancelBookingRuleRequest.put("cancelBookingBeforeMinutes","60");
        cancelBookingRuleRequest.put("cancelBookingBeforeUnit","hour");
        cancelBookingRuleRequest.put("limit",true);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("scanSignIn",true);
        object.put("signInBeforeMinutes","999");
        object.put("expireAutoSignIn",true);
        object.put("bookingStartRuleRequest",bookingStartRuleRequest);
        object.put("bookingEndRuleRequest",bookingEndRuleRequest);
        object.put("cancelBookingRuleRequest",cancelBookingRuleRequest);
        object.put("id",ruleId);
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");

    }

    @Test(description = "场地预约规则全部开关关闭",priority = 1)
    public void testSaveVenueAreaBookingRules_off(){
        JSONObject bookingStartRuleRequest = new JSONObject();
        bookingStartRuleRequest.put("limit",false);

        JSONObject bookingEndRuleRequest = new JSONObject();
        bookingEndRuleRequest.put("limit",false);

        JSONObject cancelBookingRuleRequest = new JSONObject();
        cancelBookingRuleRequest.put("limit",false);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("scanSignIn",false);
        object.put("signInBeforeMinutes","999");
        object.put("expireAutoSignIn",false);
        object.put("bookingStartRuleRequest",bookingStartRuleRequest);
        object.put("bookingEndRuleRequest",bookingEndRuleRequest);
        object.put("cancelBookingRuleRequest",cancelBookingRuleRequest);
        object.put("id",ruleId);
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,object.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(XMJSONPath.readPath(response,"$.message"),"操作成功!");
    }
}
