package com.xiaomai.cases.polar.applet;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 15:49
 */
public class TestCheckXcxCashierStatus extends XMBaseTest {
    AppletTools appletTools = new AppletTools();

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_checkXcxCashierStatus")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取场馆小程序小麦收银开通状态")
    public void testCheckXcxCashierStatus(){
        String appId = appletTools.getAuthDetail().getJSONObject("result").getString("appId");

        JSONObject object = new JSONObject();
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("appId",appId);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.status"),"NOOPEN");
    }
}
