package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-04-19  16:09
 * @Description: 校验角色权限配置是否重复
 * @Version: 1.0
 */
public class TestCheckPermConfigDup extends BaseTestImpl {

    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_checkPermConfigDup", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
//                {"{\n" +
//                        "\t\"permCodes\": [\"FitHeadInfo\", \"FitIncomeExpense\", \"FitSeeOrder\", \"FitEditOrder\", \"FitSeeXmPay\", \"FitManageXmPay\", \"FitFinanceData\"],\n" +
//                        "\t\"configMap\": {\n" +
//                        "\t\t\"memberAccess\": true,\n" +
//                        "\t\t\"scheduleAccess\": false,\n" +
//                        "\t\t\"reserveAccess\": false,\n" +
//                        "\t\t\"followUpAccess\": false,\n" +
//                        "\t\t\"importAccess\": true,\n" +
//                        "\t\t\"exportAccess\": true,\n" +
//                        "\t\t\"taskAccess\": true,\n" +
//                        "\t\t\"orderAccess\": true,\n" +
//                        "\t\t\"incomeExpenseAccess\": true,\n" +
//                        "\t\t\"potentialPhoneMask\": false,\n" +
//                        "\t\t\"memberPhoneMask\": false,\n" +
//                        "\t\t\"historyPhoneMask\": false\n" +
//                        "\t},\n" +
//                        "\t\"brandId\": \"1796482011391729666\",\n" +
//                        "\t\"studioId\": \"1800375402938871809\",\n" +
//                        "\t\"operatorId\": \"1796482250721169409\"\n" +
//                        "}",true}, // 存在有相同权限的角色
                {"{\n" +
                        "        \"permCodes\": [\"FitHeadPage\", \"FitCluePublic\", \"FitAddClue\", \"FitEditClue\", \"FitReleaseClue\"],\n" +
                        "        \"configMap\": {\n" +
                        "        \"memberAccess\": false,\n" +
                        "        \"scheduleAccess\": false,\n" +
                        "        \"reserveAccess\": false,\n" +
                        "        \"followUpAccess\": false,\n" +
                        "        \"importAccess\": false,\n" +
                        "        \"exportAccess\": false,\n" +
                        "        \"taskAccess\": false,\n" +
                        "        \"potentialPhoneMask\": true,\n" +
                        "        \"memberPhoneMask\": false,\n" +
                        "        \"historyPhoneMask\": true}}",false}  // 不存在的角色

        };
    }
    @Test(dataProvider = "data")
    public void testCheckPermConfigDup(String body,boolean flag){
        JSONObject request = JSONObject.parseObject(body);
        request.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        request.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        request.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(response.getJSONArray("result").size()>0,flag,"校验角色权限配置是否重复");

    }

}



