package com.xiaomai.cases.polar.applet;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 15:54
 */
public class TestGetExcXcxStatus extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_getExcXcxStatus")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取专属小程序状态")
    public void testGetExcXcxStatus(){
        JSONObject object = new JSONObject();
        object.put("tenantId",xmAppApi.getLoginInfo().getStudioId());
        object.put("tenantType","STUDIO");

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result"),"DONE");
    }
}
