package com.xiaomai.cases.polar.setting.courseCategory;

import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.courseCategory
 * @Author: xuyamei
 * @CreateTime: 2024-05-07  10:52
 * @Description: 课程分类是否能编辑
 * @Version: 1.0
 */
public class TestCanModifyCourseCategory extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    private String categoryId;
    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Setting,"API_canModifyCourseCategory", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }


    @Test
    public void testCanModifyCourseCategory(){
        // 创建课程分类
        categoryId = courseCategoryTools.createCourseCategory("课程分类"+ TimeUtils.getCurrentTime());
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue(courseCategoryTools.canModifyCourseCategory(categoryId,true),"没有被其他场馆使用，正常可以编辑");

    }

    @Test(description = "清除增量数据",priority = 1)
    public void del(){
        courseCategoryTools.deleteCourseCategory(categoryId);

    }
}
