package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 14:38
 */
public class TestCreate extends XMBaseTest {
    MemberTools memberTools = new MemberTools();

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Member)
                .setApiName("API_create")
                .setLoginUser(LoginAccount.ZYX_DEV)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "新增潜在会员")
    public void testCreate(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //新建潜在会员时需先校验当前场馆及同品牌下的其他场馆是否存在相同手机号的线索
        Boolean duplicate = memberTools.checkPhoneDuplicate(phone,"").getJSONObject("result").getBoolean("duplicate");
        if(duplicate == false) {
            JSONObject object = new JSONObject();
            object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("status", "POTENTIAL");
            object.put("name", name);
            object.put("phone", phone);
            object.put("gender", "UNKNOWN");

            xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(true);
            String memberId = xmAppApi.getBodyInJSON().getString("result");
            Assert.assertEquals(memberTools.getDetailById(memberId).getJSONObject("result").getString("phone"),phone);

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            Assert.assertEquals(memberTools.searchMember().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("phone"), phone);
            Assert.assertEquals(memberTools.commonSearch(phone).getJSONArray("result").getJSONObject(0).getString("id"), memberId);

        }

    }


    @Test(description = "新增潜在会员-手机号为空")
    public void testCreate_1(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);

        JSONObject object = new JSONObject();
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        object.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        object.put("status", "POTENTIAL");
        object.put("name", name);
        object.put("phone", "");
        object.put("gender", "UNKNOWN");

        xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.message"), "会员手机号格式有误;会员手机号不能为空");

    }
}
