package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 17:28
 */
public class TestSearchMember extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Member)
                .setApiName("API_searchMember")
                .setLoginUser(LoginAccount.ZYX_DEV)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "搜索潜在会员")
    public void testSearchMember(){
        JSONObject studioFilter = new JSONObject();
        studioFilter.put("studioId",xmAppApi.getLoginInfo().getStudioId());

        List statusList = new ArrayList();
        statusList.add("POTENTIAL");

        JSONObject object = new JSONObject();
        object.put("current",0);
        object.put("size",20);
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioFilter",studioFilter);
        object.put("statusList",statusList);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);
    }
}
