package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/5 17:03
 */
public class TestUpdate extends XMBaseTest {
    MemberTools memberTools = new MemberTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Member)
                .setApiName("API_forceUpdate")
                .setLoginUser(LoginAccount.ZYX_DEV)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "编辑会员")
    public void testUpdate(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

        //创建潜在会员
        String id = memberTools.create(name,phone).getString("result");

        //编辑会员时需先校验当前场馆及同品牌下的其他场馆是否存在相同手机号的线索
        Boolean duplicate = memberTools.checkPhoneDuplicate(phone,id).getJSONObject("result").getBoolean("duplicate");

        if(duplicate == false) {
            JSONObject object = new JSONObject();
            object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("status", "POTENTIAL");
            object.put("name", name);
            object.put("phone", phone);
            object.put("gender", "WOMEN");
            object.put("wechat", "微信号" + RandomStringUtil.randomString(5));
            object.put("birthday", "1268496000000");
            object.put("idCardType", "IDENTITY");
            object.put("idCardCode", "410526199710130000");
            object.put("height", "160");
            object.put("weight", "48.5");
            object.put("trainTarget", "减脂");
            object.put("profession", "互联网");
            object.put("incomeLevel", "1亿");
            object.put("address", "北京");
            object.put("emergencyContactPerson", "紧急联系人" + RandomStringUtil.randomString(3));
            object.put("emergencyContactPhone", RandomStringUtil.randomMobile("999"));
            object.put("resourceId", "12");
            object.put("remark", "这是备注这是备注这是备注这是备注这是备注这是备注这是备注这是备注这是备注这是备注");
            object.put("memberId", id);

            xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(true);
            JSONObject res = memberTools.getDetailById(id).getJSONObject("result");
            Assert.assertEquals(res.getString("gender"),"WOMEN");
            Assert.assertEquals(res.getString("birthday"),"1268496000000");
        }
    }

    @Test(description = "编辑会员-ID为空")
    public void testUpdate_1(){
        String name = "自动化潜在会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("666");

            JSONObject object = new JSONObject();
            object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
            object.put("status", "POTENTIAL");
            object.put("name", name);
            object.put("phone", phone);
            object.put("gender", "WOMEN");
            object.put("wechat", "微信号" + RandomStringUtil.randomString(5));
            object.put("birthday", "1268496000000");
            object.put("idCardType", "IDENTITY");
            object.put("idCardCode", "410526199710130000");
            object.put("height", "160");
            object.put("weight", "48.5");
            object.put("trainTarget", "减脂");
            object.put("profession", "互联网");
            object.put("incomeLevel", "1亿");
            object.put("address", "北京");
            object.put("emergencyContactPerson", "紧急联系人" + RandomStringUtil.randomString(3));
            object.put("emergencyContactPhone", RandomStringUtil.randomMobile("999"));
            object.put("resourceId", "12");
            object.put("remark", "这是备注这是备注这是备注这是备注这是备注这是备注这是备注这是备注这是备注这是备注");
            object.put("memberId", "");

            xmAppApi.doRequest(RequestType.JSON, params, object.toString(), headers).assetsSuccess(false);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.message"), "会员id不能为空");

    }
}
