package com.xiaomai.cases.lunar.minMemberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

@Component("minCardTools")
public class MinCardTools extends XMBaseTest {

    public void setUP(String apiName, DataUserInfo... userInfo) {
        dataApi.setApiModule(ApiModule.Lunar_Card)
                .setApiName(apiName)
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfo);
    }
    /**
     * @param
     * @description:小程序查看在售会员卡
     * @author: yangjian
     **/
    public JSONObject fetchOnSaleMemberCard(String title,DataUserInfo...userInfo) {
        setUP("API_fetchOnSaleMemberCard", userInfo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("title",title);//卡名称
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @param
     * @description:小程序查看在售体验卡/储值卡
     * @author: xyy
     **/
    public JSONObject fetchOnSaleMemberCard(String title,String commodityCardType,DataUserInfo...userInfo) {
        setUP("API_fetchOnSaleMemberCard", userInfo);
        JSONObject jsonObject = new JSONObject();
        //jsonObject.put("memberCardIds","");
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("title",title);//卡名称
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("commodityCardType",commodityCardType);//枚举："EXPERIENCE_CARD","DEPOSIT_CARD"

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @param
     * @description:小程序卡包数量
     * @author: xyy
     **/
    public int countMyUsableCard(String memberId, DataUserInfo...userInfo) {
        setUP("API_countMyUsableCard", userInfo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberId",memberId);
        jsonObject.put("usable",true);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return Integer.parseInt(dataApi.getBodyInJSON().getString("result"));
    }
    /**
     * @param
     * @description:小程序我的会员卡/体验卡/储值卡
     * @author: xyy
     **/
    public JSONObject getMyMemberCardList(Boolean usable,String memberId,String accountType,DataUserInfo...userInfo) {
        setUP("API_listMyMemberCard", userInfo);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("usable",usable);//可用卡true、失效卡false
        jsonObject.put("memberId",memberId);
        jsonObject.put("accountType",accountType);//卡类型：会员卡"MEMBER"、储值卡"DEPOSIT"、体验卡"EXPERIENCE"

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
