package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPageVoucherItem extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucherItem")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取财务中心-订单明细列表-无筛选")
    public void testPageVoucherItem(){
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"true","获取订单明细列表失败");
    }

    @Test(description = "获取财务中心-订单明细列表-无筛选-无卖家ID（场馆ID）、品牌ID、场馆ID、操作人ID")
    public void testPageVoucherItem1(){
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId","");
        jsonObject.put("brandId","");
        jsonObject.put("studioId","");
        jsonObject.put("operatorId","");

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(false);
    }

    @Test(description = "获取财务中心-订单明细列表-有筛选")
    public void testPageVoucherItem_sift(){
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",xmAppApi.getLoginInfo().getStudioId());

        jsonObject.put("createdStart", TimeUtils.getMonthFristDay());
        jsonObject.put("createdEnd",TimeUtils.getCurrentTime());
        jsonObject.put("lastPaymentTimeStart",TimeUtils.getMonthFristDay());
        jsonObject.put("lastPaymentTimeEnd",TimeUtils.getCurrentTime());
        jsonObject.put("operationTimeStart", TimeUtils.getMonthFristDay());
        jsonObject.put("operationTimeEnd",TimeUtils.getCurrentTime());

        JSONArray salesmanIds=new JSONArray();
        salesmanIds.add(xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("salesmanIds",salesmanIds);

        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);

        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"true","筛选订单明细列表失败");

    }

}
