package com.xiaomai.cases.polar.setting.venue;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.stereotype.Component;
import org.testng.Assert;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.venue
 * @Author: xuyamei
 * @CreateTime: 2024-05-08  11:26
 * @Description: 场地工具类
 * @Version: 1.0
 */
@Component("venueAreaTools")
public class VenueAreaTools extends XMBaseTest {
    /**
     * @description:创建不带子场地的场地
     * @author: xuyamei
     * @date:  2024/5/8 13:55
     * @param groupName：场地名称
     * @return: java.lang.String
     **/
    public String createVenueArea(String groupName,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_createVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject body = new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        body.put("groupName",groupName);
        body.put("areaList",new JSONArray());
        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    /**
     * 创建带子场地的场地
     * @return
     */
    public String saveVenueArea(DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_createVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        //构建子场地信息
        JSONArray areaList = new JSONArray();
        JSONObject oneArea = new JSONObject();
        oneArea.put("areaName","子场地-1");
        oneArea.put("usageRatio",0);
        JSONObject twoArea = new JSONObject();
        twoArea.put("areaName","子场地-2");
        twoArea.put("usageRatio",0);
        areaList.add(oneArea);
        areaList.add(twoArea);

        //构建请求
        JSONObject body = new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        body.put("groupName","西湖场地"+RandomStringUtil.randomString(5));
        body.put("areaList",areaList);

        //调用参数
        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }

    /**
     * 删除场地
     * @param groupId
     * @param userInfos
     */
    public void deleteVenueArea(String groupId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_deleteVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject body= new JSONObject();
        body.put("groupId",groupId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
    }

    /**
     * @description:查看场地列表数据
     * @author: xuyamei
     * @date:  2024/5/8 13:58
     * @return: ：返回列表数据
     **/
    public JSONObject getVenueAreaPage() {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("current",0);
        body.put("size",100);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }

    /**
     * 获取场地组列表
     * @return
     */
    public JSONObject getVenueAreaSuiteList() {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaSuiteList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        String[] stateEnumList = {"ON", "OFF"};

        JSONObject body= new JSONObject();
        body.put("stateEnumList",stateEnumList);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * @description:编辑场地
     * @author: xuyamei
     * @date:  2024/5/8 14:14
     * @param groupId ：场地id
     * @param groupName ：场地名称
     * @return: void
     **/
    public void editVenueAreaPage(String groupId,String groupName) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_editVenueArea")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("groupName",groupName);
        body.put("groupId",groupId);
        body.put("areaList",new JSONArray());
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
    }
    /**
     * @description:根据课程id获取场地详情
     * @author: xuyamei
     * @date:  2024/5/8 14:14
     * @param courseId ：课程id
     * @return:
     **/
    public JSONObject getListByStudioCourseId(String courseId){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getListByStudioCourseId")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("brandCourseId",courseId);
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");

    }
    /**
     * 通用设置-预约规则-获取场地预约规则
     * @return
     */
    public String getVenueAreaBookingRules() {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaBookingRules")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject object = new JSONObject();
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result.id");
    }
    /**
     * 创建/编辑场地组
     * @return
     */
    public String createOrEditVenueAreaSuite(String venueId,String suiteName,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_saveVenueAreaSuite")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONArray propagandaPictureList = new JSONArray();
        propagandaPictureList.add("1851146496925679617");//场地组平面图固定

        JSONObject object = new JSONObject();
        object.put("name",suiteName);
        object.put("propagandaPictureList",propagandaPictureList);
        object.put("spanMinutes","30");
        object.put("lowestPrice","0");
        object.put("startMinute","0");
        object.put("endMinute","1440");//00:00~24:00
        object.put("lowerLimitTimes","-1");//下限
        object.put("upperLimitTimes","-1");//上限
        object.put("noticeContent","{\"way\":\"auto\"}");
        object.put("needNotice",false);
        object.put("introduction","{\"items\":[{\"type\":\"TEXT\",\"content\":\"自动化脚本创建场地组介绍\",\"aspect\":\"\"}]}");
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("id",venueId);
        //id不为空，则编辑场地组
        if (null != venueId) {
            object.put("planePictureList",new JSONArray());
        }else {
            object.put("state","ON");
            object.put("tags",new JSONArray());
        }

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return XMJSONPath.readPath(dataApi.getApi_response(), "$.result");
    }
    /**
     * 启用/停用/删除场地组
     * @param suiteId
     * @param state:"ON","OFF","DELETE"
     * @return
     */
    public void saveVenueAreaSuite(String suiteId,String state,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_saveVenueAreaSuite")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("id",suiteId);
        object.put("state",state);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
    }
    /**
     * 获取场地组详情
     * @param suiteId
     * @return
     */
    public JSONObject getVenueAreaSuiteById(String suiteId) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaSuiteById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject object = new JSONObject();
        object.put("id", suiteId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return dataApi.getBodyInJSON();
    }
    /**
     * 场地组可预约时间
     * @param suiteId
     * @return
     */
    public JSONObject getSuiteVenueAreaTimeList(String suiteId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getSuiteVenueAreaTimeList")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("id", suiteId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return dataApi.getBodyInJSON();
    }

    /**
     * 场地组下面可添加的场地
     * @return
     */
    public JSONObject getEnableVenueAreas(DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getEnableVenueAreas")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return dataApi.getBodyInJSON();
    }

    /**
     * 场地组绑定场地
     * @param suiteId
     * @param groupId
     * @param userInfos
     * @return
     */
    public JSONObject bindVenueAreas(String suiteId,String groupId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_bindVenueAreas")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONArray venueGroupIds = new JSONArray();
        venueGroupIds.add(groupId);

        JSONObject object = new JSONObject();
        object.put("suiteId", suiteId);
        object.put("venueGroupIds", venueGroupIds);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return dataApi.getBodyInJSON();
    }

    /**
     * 场地组移除场地
     * @param suiteId
     * @param groupId
     * @param userInfos
     */
    public void unbindVenueAreas(String suiteId,String groupId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_unbindVenueAreas")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONArray venueGroupIds = new JSONArray();
        venueGroupIds.add(groupId);

        JSONObject object = new JSONObject();
        object.put("suiteId", suiteId);
        object.put("venueGroupIds", venueGroupIds);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
    }

    /**
     * 场地组预约时间设置
     * @param venueGroupId
     * @param userInfos
     * @return
     */
    public JSONObject getVenueAreaGroupTime(String venueGroupId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaGroupTime")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("venueGroupId", venueGroupId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return dataApi.getBodyInJSON();
    }

    /**
     * 获取场地组时间区间
     * @param suiteId
     * @param userInfos
     * @return
     */
    public JSONObject getVenueAreaSuiteTimePeriods(String suiteId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getVenueAreaSuiteTimePeriods")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("id", suiteId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        return dataApi.getBodyInJSON();
    }

    /**
     * 批量创建可预约时间
     * @param suiteId
     * @param groupId
     */
    public void createBatchNormalDate(String suiteId,String groupId,String fullPrice,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_createBatchNormalDate")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        String[] weekdays= {"MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"};

        //构建配置时间
        JSONArray timePeriodConfigInfos = new JSONArray();
        JSONObject timePeriod = new JSONObject();
        timePeriod.put("minuteOffset","0");
        timePeriod.put("spanMinutes","1440");
        timePeriod.put("fullPrice",fullPrice);//全场价格
        timePeriod.put("subPrice","0.00");//子场地价格0元
        timePeriodConfigInfos.add(timePeriod);
        //构建可约时间段
        JSONArray normalTimeInfoRequests = new JSONArray();
        JSONObject normalTimeInfo = new JSONObject();
        normalTimeInfo.put("timePeriodConfigInfos",timePeriodConfigInfos);
        normalTimeInfo.put("weekdays",weekdays);
        normalTimeInfoRequests.add(normalTimeInfo);

        //构建场地组
        JSONArray venueGroupIds = new JSONArray();
        venueGroupIds.add(groupId);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("normalTimeInfoRequests", normalTimeInfoRequests);
        object.put("suiteId", suiteId);
        object.put("venueGroupIds", venueGroupIds);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
    }

    /**
     * 检验场地组名是否重名
     */
    public Boolean checkExistsName(String suiteName, DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_checkExistsName")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("name", suiteName);
        object.put("id", "");
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getBoolean("result");
    }

    /**
     * 场地预约记录列表
     * @return
     */
    public JSONObject pageVenueBooking() {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_pageVenueBooking")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("venueArea", null);
        object.put("venueAreaId", null);
        object.put("state", null);
        object.put("checkIn", null);
        object.put("suiteId", null);
        object.put("reserveDayStart", null);
        object.put("reserveDayEnd", null);
        object.put("current", 0);
        object.put("size", 20);
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());
        object.put("brandId", dataApi.getLoginInfo().getBrandId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 场地预约记录详情
     */
    public JSONObject countVenueBookingRefundFail(DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_countVenueBookingRefundFail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 场地预约人工签到
     */
    public JSONObject manualCheckIn(String venueBookingRecordId, DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_manualCheckIn")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", venueBookingRecordId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        return dataApi.getBodyInJSON();
    }
    /**
     * 场地预约扫码签到
     */
    public JSONObject scanCheckIn(String venueBookingRecordId, DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_scanCheckIn")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("identifier", venueBookingRecordId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 场地预约记录详情
     */
    public JSONObject venueBookingRecordGetDetail(String venueBookingRecordId, DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_venueBookingRecordGetDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", venueBookingRecordId);
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 小程序我的可预约的场地
     */
    public JSONObject getEnableReserveVenueAreaSuiteList(DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getEnableReserveVenueAreaSuiteList")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("selectedDate",TimeUtils.getTodayTime());//当天的0点

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 小程序推荐场地列表
     */
    public JSONObject getVenueAreaSuitePage(DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getVenueAreaSuitePage")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        String[] stateEnumList = {"ON"};

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("suiteIds",new JSONArray());
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("stateEnumList",stateEnumList);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 小程序查看场地组详情
     */
    public JSONObject getVenueAreaSuiteDetail(String suiteId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getVenueAreaSuiteDetail")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", suiteId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 获取场地组预约时间块
     * @param suiteId
     * @param userInfos
     * @return
     */
    public JSONObject getSuiteReserveTimeBlock(String suiteId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getSuiteReserveTimeBlock")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("suiteId", suiteId);
        object.put("selectedDate", TimeUtils.getTodayTime());//当天的0点

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    /**
     * 小程序场地预约时获取场地规则
     * @param userInfos
     * @return
     */
    public JSONObject venueAreaBookingRulesGet(DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_venueAreaBookingRulesGet")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }


    /**
     * 小程序场地预约
     * @param startMinute 开始时间
     * @param endMinute 结束时间
     * @param suiteId 场地组id
     * @param groupId 场地id
     * @param memberId 会员id
     * @param reserveDay 预约日期
     * @param areaId 子场地id
     * @param userInfos
     * @return
     */
    public String purchaseAreaTimes(String startMinute, String endMinute,String suiteId, String groupId,
                                  String memberId,String reserveDay,String areaId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_purchaseAreaTimes")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        JSONArray areaTimeInfos = new JSONArray();
        JSONObject areaTime = new JSONObject();
        areaTime.put("startMinute",startMinute);//预约开始时间
        areaTime.put("endMinute",endMinute);//预约结束时间
        areaTime.put("price","0.00");//不需要支付金额
        areaTimeInfos.add(areaTime);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("areaTimeInfos", areaTimeInfos);
        object.put("groupId", groupId);//场地id
        object.put("memberId", memberId);
        object.put("memo", "自动化脚本创建的场地预约");
        object.put("objectId", RandomStringUtil.randomString(16));
        object.put("receivableAmount", "0.00");
        object.put("reserveDay", reserveDay);
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("suiteId", suiteId);//场地组id
        object.put("venueAreaId", areaId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));

        return dataApi.getBodyInJSON().getJSONObject("result").getString("id");
    }
    /**
     * 小程序场地预约冲突提示
     */
    public JSONObject checkMemberVenueBookingConflict(String startMinute,String endMinute,String price,String groupId,
                                                      String memberId,String reserveDay,String areaId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_checkMemberVenueBookingConflict")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        JSONArray areaTimeInfos = new JSONArray();
        JSONObject areaTime = new JSONObject();
        areaTime.put("startMinute",startMinute);//预约开始时间
        areaTime.put("endMinute",endMinute);//预约结束时间
        areaTime.put("price",price);//场地单价
        areaTimeInfos.add(areaTime);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("areaTimeInfos", areaTimeInfos);
        object.put("groupId", groupId);
        object.put("memberId", memberId);
        object.put("reserveDay", reserveDay);
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("venueAreaId", areaId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 小程序允许场地预约
     */
    public String checkAllowVenueBooking(String startMinute,String endMinute,String price,String groupId,
                                         String memberId,String reserveDay,String suiteId,String areaId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_checkAllowVenueBooking")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        JSONArray areaTimeInfos = new JSONArray();
        JSONObject areaTime = new JSONObject();
        areaTime.put("startMinute",startMinute);//预约开始时间
        areaTime.put("endMinute",endMinute);//预约结束时间
        areaTime.put("price",price);//场地单价
        areaTimeInfos.add(areaTime);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("areaTimeInfos", areaTimeInfos);
        object.put("groupId", groupId);
        object.put("memberId", memberId);
        object.put("reserveDay", reserveDay);
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("suiteId", suiteId);
        object.put("venueAreaId", areaId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON().getString("result");
    }
    /**
     * 小程序场地预约的订单详情
     */
    public JSONObject getByVoucher(String voucherId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getByVoucher")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", voucherId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 小程序我的预约场地列表
     */
    public JSONObject pageMemberVenueBooking(String state,String memberId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_pageMemberVenueBooking")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("current", 0);
        object.put("state", state);
        object.put("size", 20);
        object.put("memberId", memberId);
        object.put("reserveDayStart", TimeUtils.getStartYear());
        object.put("reserveDayEnd", TimeUtils.getEndYear());

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    /**
     * 小程序我的-我的预约-场地-预约详情
     */
    public JSONObject getVenueBookingRecordDetail(String venueBookingRecordId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getVenueBookingRecordDetail")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", venueBookingRecordId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
    public void getCheckInIdentifier(String venueBookingRecordId,DataUserInfo...userInfos) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_getCheckInIdentifier")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest(userInfos);

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", venueBookingRecordId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.result"),"SUCCESS");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.identifier"),venueBookingRecordId);
    }
    /**
     * 小程序取消场地预约
     */
    public void cancelVenueBookingRecord(String venueBookingRecordId) {
        dataApi.setApiModule(ApiModule.Lunar_VenueArea)
                .setApiName("API_cancelVenueBookingRecord")
                .setTerminal(Terminal.minApp);
        super.beforeDataRequest();

        //构建请求参数
        JSONObject object = new JSONObject();
        object.put("id", venueBookingRecordId);

        dataApi.doRequest(RequestType.JSON, dataparams, object.toString(), dataheadrs).assetsSuccess(true);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
    }


}
