package com.xiaomai.jdbc.dao.impl;

import com.xiaomai.jdbc.dao.DataDao;
import com.xiaomai.jdbc.entity.ApiInfo;
import com.xiaomai.jdbc.entity.UserInfo;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import java.util.List;

/**
 * @Auther: pdd
 * @Date: 2021/04/27/16:29
 * @Description: 获取数据信息
 */
public class DataDaoImpl implements DataDao {

    // 声明一个JdbcTmplate属性及其Setter方法
    private static JdbcTemplate jdbcTemplate;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }


    @Override
    public UserInfo getUserInfo(String userName, String env) {
        // 定义SQL
        String sql = "SELECT * FROM user_info WHERE user_name = ? and env = ? limit 1";
        // 定义数组来存放SQL语句中的参数
        Object[] obj = new Object[]{userName, env};
        RowMapper<UserInfo> rowMapper = new BeanPropertyRowMapper<>(UserInfo.class);
        List<UserInfo> userInfos = this.jdbcTemplate.query(sql, obj, rowMapper);

        return userInfos.size() > 0 ? userInfos.get(0) : null;
    }

    @Override
    public List<UserInfo> getUserInfos(String userType, String env) {
        // 定义SQL
        String sql = "SELECT * FROM user_info WHERE user_type = ? and env = ? limit 1";
        // 定义数组来存放SQL语句中的参数
        Object[] obj = new Object[]{userType, env};
        RowMapper<UserInfo> rowMapper = new BeanPropertyRowMapper<>(UserInfo.class);
        List<UserInfo> userInfos = this.jdbcTemplate.query(sql, obj, rowMapper);
        return userInfos;
    }


    /**
     * @Description: 获取测试接口信息
     * @Author: pdd
     * @Date: 2021/4/27/16:09
     */
    @Override
    public ApiInfo getApiInfo(String apiModule, String apiName) {
        // 定义SQL
        String sql = "SELECT * FROM api_info WHERE api_module = ? and api_name = ? limit 1";
        // 定义数组来存放SQL语句中的参数
        Object[] obj = new Object[]{apiModule, apiName};
        RowMapper<ApiInfo> rowMapper = new BeanPropertyRowMapper<>(ApiInfo.class);
        List<ApiInfo> apiInfos = this.jdbcTemplate.query(sql, obj, rowMapper);

        return apiInfos.size() > 0 ? apiInfos.get(0) : null;

    }


}
