package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 训练营活动列表筛选下测试
 *
 * @author adu
 * data 2024/7/5 18:08
 */

public class TestSearchTrainingList extends BaseCreateTrainingData {
    @Resource(name = "trainingTools")
    TrainingTools trainingTools;
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Training, "API_searchTrainingList", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @DataProvider(name = "filterTrainingListDateByCondition")
    public Object[][] dataProvider() {

        List<String> statu1 = new ArrayList<>();
        statu1.add("UNPUBLISHED");//未发布
        List<String> statu2 = new ArrayList<>();
        statu2.add("APPLY_NOT_START");//报名未开始
        List<String> statu3 = new ArrayList<>();
        statu3.add("APPLYING");//报名中
        List<String> statu4 = new ArrayList<>();
        statu4.add("TO_BE_OPEN");//待开营
        List<String> statu5 = new ArrayList<>();
        statu5.add("OPENING");//进行中
        List<String> statu6 = new ArrayList<>();
        statu6.add("CLOSED");//已结束
        List<String> statu7 = new ArrayList<>();
        statu7.add("CANCEL");//已取消
        List<String> statu8 = new ArrayList<>(); //训练营排课时选择以下4种状态的活动
        statu8.add("APPLY_NOT_START");//报名未开始
        statu8.add("APPLYING");//报名中
        statu8.add("TO_BE_OPEN");//待开营
        statu8.add("OPENING");//进行中

        return new Object[][]{
                { "", "", new ArrayList<>()},//无筛选条件
                { courseId, "", new ArrayList<>()},//根据关联课程搜索
                { "", "杭州自动化测试训练营", statu8},//根据训练营名称搜索
                { "", "", statu1},//根据训练营状态（未发布）搜索
                { "", "", statu2},//根据训练营状态（报名未开始）搜索
                { "", "", statu3},//根据训练营状态（报名中）搜索
                { "", "", statu4},//根据训练营状态（待开营）搜索
                { "", "", statu5},//根据训练营状态（进行中）搜索
                { "", "", statu6},//根据训练营状态（已结束）搜索
                { "", "", statu7},//根据训练营状态（已取消）搜索
                { courseId, "", statu1},//根据训练营状态（未发布）和关联课程搜索
                { courseId, "", statu2},//根据训练营状态（报名未开和关联课程搜索
                { courseId, "", statu3},//根据训练营状态（报名中）和关联课程搜索
                { courseId, "", statu4},//根据训练营状态（待开营）和关联课程搜索
                { courseId, "", statu5},//根据训练营状态（进行中）和关联课程搜索
                { courseId, "", statu6},//根据训练营状态（已结束）和关联课程搜索
                { courseId, "", statu7},//根据训练营状态（已取消）和关联课程搜索
        };
    }
    @Test(dataProvider = "filterTrainingListDateByCondition")
    public void testSearchTrainingList(String courseId,String title,List<String> stateList){
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("current", 0);
        body.put("size", 20);
        body.put("courseId", courseId);
        body.put("stateList", stateList);
        body.put("title", title);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        //有存量数据，理论上每个查询都会至少有1条数据
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(xmAppApi.getApi_response(),"$.result.records").size()>=1,"没有搜索到相关数据");




    }
}

    