package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;


public class OrderTools extends XMBaseTest {

    /**
     * @param
     * @description:获取会员详情-订单管理列表
     * @param supplierId：卖家ID 场馆ID
     * @param receiverId：会员ID
     * @author: yangfangfang
     **/
    public JSONObject pageMemberVoucher(String supplierId,String receiverId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageMemberVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取会员详情-订单管理金额统计
     * @param supplierId：卖家ID 场馆ID
     * @param receiverId：会员ID
     * @author: yangfangfang
     **/
    public JSONObject sumMemberVoucherAmount(String supplierId,String receiverId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumMemberVoucherAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取会员详情-订单明细列表
     * @param supplierId：卖家ID 场馆ID
     * @param receiverId：会员ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageMemberVoucherItem(String supplierId,String receiverId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageMemberVoucherItem")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("receiverId",receiverId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取订单管理-订单管理列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageVoucher(String supplierId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:搜索订单管理-订单管理列表
     * @param supplierId：卖家ID 场馆ID
     * @param businessNo：订单编号
     * @author: yangfangfang
     **/
    public JSONObject pageVoucher1(String supplierId,String businessNo,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("businessNo",businessNo);


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }



    /**
     * @param
     * @description:获取订单管理-订单管理金额统计
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject sumVoucherAmount(String supplierId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumVoucherAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("supplierId", supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单明细列表
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject pageVoucherItem(String supplierId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pageVoucherItem")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取订单管理-订单明细金额统计
     * @param supplierId：卖家ID 场馆ID
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject sumVoucherItemAmount(String supplierId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_sumVoucherItemAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("supplierId",supplierId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description: 获取会员卡列表
     * @author: yangfangfang
     **/
    public JSONObject fetchPageOfMemberCard(String title,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchPageOfMemberCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("title",title);
        jsonObject.put("shelfState","YES");
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description: 获取会员卡详情
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject fetchDetailById(String id,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchDetailById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description: 检查会员对该卡是否超出购买上限
     * @param skuType:商品类型：[ MEMBER_CARD, TRAINING_CAMP, SINGLE_RESERVE, EXPERIENCE_CARD   "会员卡", "训练营", "单次约课", "体验卡"
     * @param skuId：场馆ID
     * @param memberId：会员ID
     * @param quantity：卡张数，默认为1
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject checkAllowPurchase(String skuType,String skuId,String memberId,String quantity,String brandId,String studioId,String operatorId,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkAllowPurchase")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("skuType",skuType);
        jsonObject.put("skuId",skuId);
        jsonObject.put("memberId",memberId);
        jsonObject.put("quantity",quantity);
        jsonObject.put("brandId",brandId);
        jsonObject.put("studioId",studioId);
        jsonObject.put("operatorId",operatorId);

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }





    /**
     * @param
     * @description: 检查会员对该卡是否超出购买上限
     * @param cardId:卡id
     * @param cardSnapshotId：卡快照id
     * @param quantity：次数
     * @param price：卡的价格
     * @param validPeriod:有效期
     * @param deductionAmount:优惠金额
     * @param activatePattern:激活方式  [ "即时生效", "首次使用生效", "指定日期生效" ][ PURCHASE, FIRST_USED, SPECIFIC_DATE ]
     * @param commodityCardType:卡商品类型 [ MEMBER_CARD, TRAINING_CAMP, SINGLE_RESERVE, EXPERIENCE_CARD   "会员卡", "训练营", "单次约课", "体验卡"
     * @param memberId：会员ID
     * @param receivableAmount：应收金额  就是优惠之后的小计
     * @param amount：支付金额 支付信息输入的金额
     * @param paymentWay：支付方式
     * @author: yangfangfang
     **/

    public JSONObject signOrder(String cardId,String cardSnapshotId,int quantity,float price,int validPeriod,String latestSnapshotId,float deductionAmount,String activatePattern,
                                String commodityCardType,String memberId,float receivableAmount,float amount,String paymentWay,DataUserInfo...dataUserInfos){


        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_signOrder")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("salesmanId",dataApi.getLoginInfo().getAdminId());
        jsonObject.put("operationTime", TimeUtils.getCurrentTime());

        JSONObject card=new JSONObject();
        card.put("cardId",cardId);
        card.put("cardSnapshotId",cardSnapshotId);

        JSONObject cardChange=new JSONObject();
        cardChange.put("quantity",quantity);
        cardChange.put("price",price);
        cardChange.put("validPeriod",validPeriod);
        cardChange.put("latestSnapshotId",latestSnapshotId);


        card.put("cardChange",cardChange);
        card.put("deductionAmount",deductionAmount);//优惠金额（元）
        card.put("activatePattern",activatePattern);
        card.put("commodityCardType",commodityCardType);
        jsonObject.put("card",card);


        jsonObject.put("objectId", RandomStringUtil.randomString(20));
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memberId",memberId);
        jsonObject.put("receivableAmount",receivableAmount);//应收金额
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        JSONArray paymentWays=new JSONArray();

        JSONObject object=new JSONObject();
        object.put("amount",amount);//支付金额
        object.put("paymentWay",paymentWay);
        JSONArray voucherResourceIds=new JSONArray();//支付凭证
        voucherResourceIds.add("");
        object.put("voucherResourceIds",voucherResourceIds);
        paymentWays.add(object);

        jsonObject.put("paymentWays",paymentWays);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description: 获取订单详情
     * @param id:主键ID（创建订单获取的result）
     * @author: yangfangfang
     **/
    public JSONObject getDetail(String id,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_getDetail")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:获取订单支付/退款记录
     * @param id：主键ID 创建订单接口的result
     * @author: yangfangfang
     **/
    public JSONObject listByVoucherId(String id, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_listByVoucherId")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:修改对内备注
     * @param voucherId：主键ID 创建订单接口的result  订单id
     * @param supplierInnerMemo：对内备注
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject modifySupplierInnerMemo(String voucherId,String supplierInnerMemo,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_modifySupplierInnerMemo")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("voucherId",voucherId);
        jsonObject.put("supplierInnerMemo",supplierInnerMemo);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:修改对外备注
     * @param voucherId：主键ID 创建订单接口的result  订单id
     * @param supplierMemo：对外备注
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject modifySupplierMemo(String voucherId,String supplierMemo, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_modifySupplierMemo")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("voucherId",voucherId);
        jsonObject.put("supplierMemo",supplierMemo);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:校验作废订单
     * @param id：主键ID 创建订单接口的result  订单id
     * @param brandId:品牌ID
     * @param studioId：场馆ID
     * @param operatorId：操作人ID
     * @author: yangfangfang
     **/
    public JSONObject checkDiscardVoucher(String id,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkDiscardVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:作废订单
     * @param id：主键ID 创建订单接口的result  订单id
     * @author: yangfangfang
     **/
    public JSONObject discard(String id,String discardCause,String discardMemo, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_discard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("discardCause",discardCause);
        jsonObject.put("discardMemo",discardMemo);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }



    /**
     * @param
     * @description:取消订单
     * @param id：主键ID 创建订单接口的result  订单id
     * @author: yangfangfang
     **/
    public JSONObject cancel(String id,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_cancel")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id",id);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:查询订单或者收支可退流水金额（包含乐动收银状态信息
     * @param voucherId：订单id
     * @param shouldRefundAmount:应退金额
     * @author: yangfangfang
     **/
    public JSONObject checkRefundableAmount(String voucherId, float shouldRefundAmount, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_checkRefundableAmount")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("voucherId",voucherId);
        jsonObject.put("shouldRefundAmount",shouldRefundAmount);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:退单
     * @param giftQuantity：退出赠送数量
     * @param memberCardId:会员的卡id  从listUserRefundableCard中的id获取 不是买的时候的卡id
     * @param quantity：退出购买数量
     * @param refundAmount：退出金额
     * @param commodityCardType：卡商品类型[ MEMBER_CARD, EXPERIENCE_CARD, DEPOSIT_CARD ]
     * @param memberId：会员ID
     * @param receivableAmount：应退金额
     * @param amount：支付金额
     * @param paymentWay：支付方式
     * @author: yangfangfang
     **/
    public JSONObject refundOrder(int giftQuantity, String memberCardId,int quantity,float refundAmount,String commodityCardType,String  memberId, float receivableAmount,
                                   float amount,String paymentWay,DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_refundOrder")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("operationTime",TimeUtils.getCurrentTime());

        JSONObject card=new JSONObject();
        card.put("giftQuantity",giftQuantity);
        card.put("memberCardId",memberCardId);
        card.put("quantity",quantity);
        card.put("refundAmount",refundAmount);
        card.put("commodityCardType",commodityCardType);
        jsonObject.put("card",card);

        jsonObject.put("objectId", RandomStringUtil.randomString(20));
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("memberId",memberId);
        jsonObject.put("receivableAmount",receivableAmount);
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());


        JSONArray paymentWays=new JSONArray();

        JSONObject jsonObject1=new JSONObject();
        jsonObject1.put("amount",amount);
        jsonObject1.put("paymentWay",paymentWay);

        JSONArray voucherResourceIds=new JSONArray();
        voucherResourceIds.add("");
        jsonObject1.put("voucherResourceIds",voucherResourceIds);

        paymentWays.add(jsonObject1);
        jsonObject.put("paymentWays",paymentWays);

        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }



    /**
     * @param
     * @description:查询用户可退的会员卡列表
     * @param accountType：账户类型 [ MEMBER, TRAINING, EXPERIENCE, SINGLE_RESERVE, DEPOSIT ]
     * @param content:搜索内容
     * @param memberId:搜索内容
     * @author: yangfangfang
     **/
    public JSONObject listUserRefundableCard(String accountType, String content,String memberId,  DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_listUserRefundableCard")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("accountType",accountType);
        jsonObject.put("content",content);
        jsonObject.put("memberId",memberId);
        jsonObject.put("brandId",dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:继续收款
     * @param unpaidAmount：欠费金额
     * @param getDetailId:订单ID
     * @param paymentWay:支付方式 1-线下微信 2 3
     * @author: yangfangfang
     **/
    public JSONObject pay(float unpaidAmount,String paymentWay,String getDetailId, DataUserInfo...dataUserInfos){

        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_pay")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("operationTime", TimeUtils.getCurrentTime());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        JSONArray paymentWays = new JSONArray();

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("amount", unpaidAmount);
        jsonObject1.put("paymentWay",paymentWay);

        JSONArray voucherResourceIds = new JSONArray();
        voucherResourceIds.add("");
        jsonObject1.put("voucherResourceIds", voucherResourceIds);
        paymentWays.add(jsonObject1);

        jsonObject.put("paymentWays", paymentWays);
        jsonObject.put("voucherId", getDetailId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response=dataApi.getBodyInJSON();
        return response;
    }


}
