package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.cases.polar.finance.revenueAndExpenditure.RevenueAndExpenditureTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestForceUpdate extends XMBaseTest {
    String cardId;

    OrderTools orderTools=new OrderTools();

    RevenueAndExpenditureTools revenueAndExpenditureTools=new RevenueAndExpenditureTools();

    CardTools cardTools=new CardTools();
    Tools tools= new Tools();


    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_forceUpdate")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "编辑正式会员信息")
    public void  testForceUpdate() {


        JSONObject create=tools.create("编辑正式会员"+RandomStringUtil.randomString(3),RandomStringUtil.randomMobile("88"));
        String memberId=create.getString("result");

        //创建订单转成正式会员

        //获取会员卡信息
        //获取会员卡列表,没有则新建一个
        int cardTotal = Integer.parseInt(orderTools.fetchPageOfMemberCard("次卡").getJSONObject("result").getString("total"));
        if (cardTotal == 0) {
            cardId = cardTools.memberCardCreate("创建订单会员卡"+TimeUtils.getCurrentTime()).getString("result");
        }
        JSONObject memberCard=orderTools.fetchPageOfMemberCard("次卡");
        cardId=memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        int quantity= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("balance"));
        float price= Float.parseFloat(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("price"));
        int validPeriod= Integer.parseInt(memberCard.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("validPeriod"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取签单要用的卡快照id
        String latestSnapshotId=orderTools.fetchDetailById(cardId,xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getJSONObject("result").getString("latestSnapshotId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //检查会员对该卡是否超出购买上限
        boolean limitResult=orderTools.checkAllowPurchase("MEMBER_CARD",cardId,memberId,"1",xmAppApi.getLoginInfo().getBrandId(),xmAppApi.getLoginInfo().getStudioId(),xmAppApi.getLoginInfo().getAdminId()).getBoolean("success");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        if(limitResult == true) {

            //创建订单
            JSONObject orderResult = orderTools.signOrder(cardId, latestSnapshotId, quantity, price, validPeriod, latestSnapshotId, price / 2, "PURCHASE",
                    "MEMBER_CARD", memberId, price - price / 2, price - price / 2, "1");
            String getDetailId = orderResult.getString("result");

            try {
                Thread.sleep(3000);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }

        }

        //获取正式会员列表
        JSONObject memberResult=tools.search("NORMAL","NORMAL");

        int memberResultPages=Integer.parseInt(memberResult.getJSONObject("result").getString("pages"));
        int memberResultTotal=Integer.parseInt(memberResult.getJSONObject("result").getString("total"));


        for(int k=0; k == memberResultPages+1; k++){
            int n =k==memberResultPages ? (memberResultTotal%10==0 ? 10 : memberResultTotal%10) : 10;
            JSONArray records=memberResult.getJSONObject("result").getJSONArray("records");
            boolean flag=true;
            for(int i=0; i<n; i++){
                String memberResultId=records.getJSONObject(i).getString("id");
                if(memberResultId.equals(memberId)){
                    flag = true;
                    break;
                }
            }
            Assert.assertEquals(true,flag,"潜在会员购买订单已完成,但会员状态转成正式会员失败");
        }

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //编辑
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("status", "POTENTIAL");
        jsonObject.put("name", "自动化正式会员" + RandomStringUtil.randomString(2));
        jsonObject.put("phone", RandomStringUtil.randomMobile("22"));
        jsonObject.put("gender", "WOMEN");
        jsonObject.put("wechat", RandomStringUtil.randomMobile("66"));
        jsonObject.put("birthday", TimeUtils.getBeforeDayDate(10));
        jsonObject.put("idCardType", "IDENTITY");
        jsonObject.put("idCardCode", "411421199808080225");
        jsonObject.put("height", "186");
        jsonObject.put("weight", "76");
        jsonObject.put("trainTarget", "塑形"+RandomStringUtil.randomString(2));
        jsonObject.put("profession", "金融"+RandomStringUtil.randomString(2));
        jsonObject.put("incomeLevel", "亿万富翁"+RandomStringUtil.randomString(2));
        jsonObject.put("address", "地址"+RandomStringUtil.randomString(6));
        jsonObject.put("emergencyContactPerson", RandomStringUtil.randomString(3));
        jsonObject.put("emergencyContactPhone", RandomStringUtil.randomMobile("66"));
        jsonObject.put("resourceId", "1");
        jsonObject.put("intention", "HIGH");
        jsonObject.put("creatorId", xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("remark", "备注"+RandomStringUtil.randomString(12));
        jsonObject.put("memberId", memberId);


        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$success"),"true","编辑正式会员信息失败");


    }

}
