package com.xiaomai.cases.polar.schedule.group;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 团课课表，分享课表-下载课表
 *
 * @author adu
 * data 2024/11/6 10:26
 */

public class TestSaveShareScheduleConfig extends BaseTestImpl {
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;

    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Schedule, "API_saveShareScheduleConfig", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();

    }

    @Test(description = "测试团课课表-分享课表-下载课表")
    public void testSaveShareScheduleConfig() {
        //点击分享获取课表配置信息：默认配置
        groupScheduleTools.getShareScheduleConfig();
        JSONObject configInfo= XMJSONPath.getJSONObjectByReadPath(dataApi.getApi_response(),"$.result");

        //什么都不操作，走默认配置，下载课表
        groupScheduleTools.saveShareScheduleConfig(configInfo);

        //修改配置，然后操作下载课表check
        JSONObject body = new JSONObject();
        String shareTitle="阿杜测试团课课表分享";
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("shareTitle",shareTitle);
        body.put("showCustomBg", false);
        body.put("showCustomQrCode", false);
        List<String> showContent=new ArrayList<>();
        showContent.add("COACH_NICK_NAME");
        showContent.add("AREA_NAME");
        body.put("showContent", showContent);
        //修改后再调用获取配置接口check是否同步修改
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(),"$.success"))==true,"调用接口返回结果："+XMJSONPath.readPath(xmAppApi.getApi_response(),"$.message"));
       //查看配置信息
        groupScheduleTools.getShareScheduleConfig();
        Assert.assertTrue(shareTitle.equals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.shareTitle")));
        System.out.println("***"+XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.showContent").size());
        System.out.println("***"+!XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.showContent").contains("AREA_NAME"));

        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.showContent").size()==2 && !XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.showContent").contains("COURSE_COLOR"));
        //还原配置
        groupScheduleTools.saveShareScheduleConfig(configInfo);
        //还原配置后获取配置信息
        groupScheduleTools.getShareScheduleConfig();
        JSONObject configInfoA= XMJSONPath.getJSONObjectByReadPath(dataApi.getApi_response(),"$.result");
        //check configInfoA和configInfo是否相等
        Assert.assertTrue(configInfoA.getString("shareTitle").equals(configInfo.getString("shareTitle")),"还原配置后，课表名称没恢复");
        Assert.assertTrue(configInfoA.getJSONArray("showContent").containsAll(configInfo.getJSONArray("showContent")),"还原配置后，课表内容展示没恢复默认");





    }

}

    