package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-04-23  08:26
 * @Description: 获取可用于新建角色的功能权限列表
 * @Version: 1.0
 */
public class TestStudioRoleGetPermList extends BaseTestImpl {
    @BeforeClass
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_studioRole_getPermList", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testStudioRoleGetPermList(){
        xmAppApi.doRequest(RequestType.JSON,params,"",headers).assetsSuccess(true);
        JSONArray jsonArray = xmAppApi.getBodyInJSONArray("$.result");
        // 校验1：校验返回结果是否包含8个功能权限
        Assert.assertEquals(jsonArray.size()>=8,true,"功能权限缺失" );
        String[] arr = {"FitHeadPageCenter","FitBrandCenter","FitSalesCenter","FitDataCenter","FitMemberCenter","FitBusinessCenter","FitFinanceCenter","FitManage"};
        JSONArray arr1 = new JSONArray();
        for (String s : arr){
            arr1.add(s);
        }

        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArray.size(); i++) {
            result.add(jsonArray.getJSONObject(i).getString("code"));
        }
        // 校验2：校验返回结果是否包含既定的功能权限
        Assert.assertEquals(result.containsAll(arr1),true,"功能权限模块缺失" );

    }
}
