package com.xiaomai.cases.polar.course;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.Random;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.course
 * @Author: xuyamei
 * @CreateTime: 2024-05-07  17:36
 * @Description: 编辑团课
 * @Version: 1.0
 */
public class TestEditGroupCourse extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Course, "API_editGroupCourse", LoginAccount.GYM_PROD, Terminal.B, "xym");
        super.beforeTest();
    }

    @Test
    public void testEditGroupCourse() {
        String categoryId = courseCategoryTools.getCourseCategoryPage("");
        String courseId = courseTools.getPersonalOrGroupCourseId("GROUP", "存量瑜伽团课课程", categoryId, "STUDIO", "", 2, 1).getString(0);
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        Random random = new Random();
        int duration = random.nextInt(60) + 10;
        int difficulty = random.nextInt(5) + 1;
        int calorie = random.nextInt(100) + 100;
        String introduction = "{\"items\":[{\"content\":\"花花世界的\",\"aspect\":\"\",\"type\":\"TEXT\"}]}";

        String courseName = "存量瑜伽团课课程" + TimeUtils.getCurrentTime();
        JSONObject body = new JSONObject();
        body.put("courseName", courseName);
        body.put("duration", duration);      // 时长
        body.put("difficulty", difficulty);     // 难度
        body.put("color", "#AACF53");
        body.put("coverId", "0");
        body.put("timeUnit", "MINUTE");
        body.put("categoryId", categoryId);
        body.put("introduction", introduction);
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("sourceId", xmAppApi.getLoginInfo().getStudioId());  // 来源：场馆、品牌
        body.put("sourceType", "STUDIO");
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId()); // 场馆
        body.put("calorie", calorie);  // 卡路里
        body.put("brandCourseId", courseId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("singleReserve", true);
        body.put("reservePrice", 0);


        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);


        String[] keys = {"courseName", "duration", "difficulty", "color", "coverId", "timeUnit", "categoryId", "sourceId", "sourceType", "brandId", "calorie"};
        String[] values = {courseName, String.valueOf(duration), String.valueOf(difficulty), "#AACF53", "0", "MINUTE", categoryId, xmAppApi.getLoginInfo().getStudioId(), "STUDIO", xmAppApi.getLoginInfo().getBrandId(), String.valueOf(calorie)};
        // 校验内容与编辑的是否一致
        JSONObject courseDetail = courseTools.getCourseDetail(courseId);
        for (int i = 0; i < keys.length; i++) {
            String result = values[i];
            Assert.assertEquals(courseDetail.getString(keys[i]), result, "编辑之后课程详情与编辑内容不一致");
        }

    }
}