package com.xiaomai.cases.polar.export;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author zxy
 * @Description
 * @Date 2024/11/15 14:53
 */
public class ExportTool extends XMBaseTest {
    //导出记录列表
    public JSONObject pageStudioExportRecord(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Export)
                .setApiName("API_pageStudioExportRecord")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("current",1);
        object.put("size",20);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());
        object.put("studioId",dataApi.getLoginInfo().getStudioId());
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //下载文件
    public JSONObject getUrl(String resourceId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Export)
                .setApiName("API_getUrl")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("resourceId",resourceId);
        object.put("brandId",dataApi.getLoginInfo().getBrandId());

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
