package com.xiaomai.cases.polar.finance.axf;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestGetAfterSalesOrder extends BaseTestImpl {
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Finance,"API_getAfterSalesOrder", LoginAccount.GYM_PROD, Terminal.B,"yff");
        super.beforeTest();
    }

    @Test(description = "获取先享后付订购单售后详情")
    public void testGetAfterSalesOrder(){

        //用的是小麦自动化校区固定的先享后付订购单id：1977663106310189057，因为不是所有的都会有售后详情

        //  如果运行的环境为灰度则不执行，原因是灰度环境没有开通先学后付
        if(xmAppApi.getUrl().contains("canary-fit.xiaomai5.com"))
            return;

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id","1977663106310189057");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        String  afterSalesState=response.getJSONObject("result").getString("afterSalesState");
        String  success=response.getString("success");
        Assert.assertEquals(success,"true","获取先享后付订购单售后详情失败");
        Assert.assertEquals(afterSalesState,"SUCCESS","先享后付订购单售后详情状态应为售后完成（退卡成功）");

    }
}
