package com.xiaomai.cases.polar.importExcel;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/2 17:31
 */
public class ImportTools extends XMBaseTest {
    //创建导入
    public JSONObject createImportTask(String taskType,String resourceId,String taskDesc,String memo,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_ImportTask)
                .setApiName("API_createImportTask")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("tenantId",dataApi.getLoginInfo().getStudioId());
        object.put("resourceId",resourceId);
        object.put("tenantType","STUDIO");
        object.put("taskType",taskType);
        object.put("taskDesc",taskDesc);
        object.put("memo",memo);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //获取导入任务
    public JSONObject getTask(String id,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_ImportTask)
                .setApiName("API_getTask")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("id",id);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //任务中心-导入记录
    public JSONObject pageImportTask(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_ImportTask)
                .setApiName("API_pageImportTask")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("operatorId",dataApi.getLoginInfo().getAdminId());
        object.put("tenantId",dataApi.getLoginInfo().getStudioId());
        object.put("tenantType","STUDIO");
        object.put("current",0);
        object.put("size",10);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //获取导入资源
    public JSONObject getImportResource(String resourceId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_ImportTask)
                .setApiName("API_getImportResource")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("tenantId",dataApi.getLoginInfo().getStudioId());
        object.put("tenantType","STUDIO");
        object.put("resourceId",resourceId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
