package com.xiaomai.cases.polar.utils;

import com.alibaba.fastjson.JSONArray;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/2 17:57
 */
public class CommonUtil {
    /**
     * 把字符串解析成JSONArray
     *
     * @param str
     * @return
     */
    public static JSONArray JsonArray2Str(String str) {
        JSONArray jsonArray = JSONArray.parseArray(str);
        return jsonArray;
    }


    /**
     * 获取手机号,以1111开头
     *
     * @param random
     * @return
     */
    public static Long getRandomPhone(Random random) {
        Integer randomNum = random.nextInt(100000000);
        return 11111000000L + randomNum;
    }


    /**
     * @param mark 打标，比如获取的是员工：员工，校长；获取的是学员：_杜同学,同学来自线索导入
     * @return 学员姓名
     */
    public static String getRandomName(String mark) {
        StringBuilder sb = new StringBuilder();
        String firstName = "杜张王李赵彭柏孙谢钮徐薛劳周程钟郭竺杨黄苏艾楼陈曹蒋牛";
        String nameMiddle = "ABCDEFGHIJKLMNOPQRSTUVWXTZ";
        String nameNum = "零一二三四五六七八九十";
        Random randomGenerator = new Random();
        int randomInt = randomGenerator.nextInt(firstName.length());
        sb.append(firstName, randomInt, randomInt + 1);
        randomInt = randomGenerator.nextInt(nameMiddle.length());
        sb.append(nameMiddle, randomInt, randomInt + 1);
        randomInt = randomGenerator.nextInt(nameNum.length());
        sb.append(nameNum, randomInt, randomInt + 1);
        if (mark != null && mark.length() != 0) {
            sb.append(mark);
        }
        return sb.toString();
    }

    /**
     * 保留2位小数
     *
     * @param d
     * @return
     */
    public static String formatDouble2(double d) {
        // 新方法，如果不需要四舍五入，可以使用RoundingMode.DOWN
        return new BigDecimal(d).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    /**
     * 保留2位小数
     *
     * @param d
     * @return
     */
    public static Double formatDouble(double d) {
        // 新方法，如果不需要四舍五入，可以使用RoundingMode.DOWN
        return new BigDecimal(d).setScale(2, RoundingMode.HALF_UP).stripTrailingZeros().doubleValue();
    }



}
