package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-07-01  10:44
 * @Description: 检查手机号是品牌下场馆的主账号
 * @Version: 1.0
 */
public class TestFindStudioBossInBrand extends BaseTestImpl {
    @Resource(name = "adminTools")
    AdminTools adminTools;
    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Admin,"API_findStudioBossInBrand", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }


    @Test(description = "手机号是品牌下的非主账号")
    public void testFindStudioBossInBrand() {
        JSONArray result = adminTools.findStudioBossInBrand();
        Assert.assertTrue(result.size()==0,"手机号非主账号但是返回任职的场馆");
    }

    @Test(description = "手机号是品牌下的主账号",priority = 1)
    public void testFindStudioBossInBrand2() {
        DataUserInfo info = new DataUserInfo();
        info.setLoginUser(LoginAccount.GYM_PROD2);
        info.setTerminal(Terminal.B);

        JSONArray result = adminTools.findStudioBossInBrand(info);
        Assert.assertTrue(result.size()>0,"手机号是主账号但是未返回任职的场馆");
    }



}
