package com.xiaomai.cases.polar.setting.rules;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.setting.rules
 * @Author: xuyamei
 * @CreateTime: 2024-05-13  16:10
 * @Description: 预约规则工具类
 * @Version: 1.0
 */
@Component("ruleTools")
public class RuleTools extends XMBaseTest {
    /**
     * @description:保存预约规则
     * @author: xuyamei
     * @date:  2024/5/13 17:31
     * @param id :规则id
     * @param allowQueuing：是否允许排队
     * @param bookingSeatCount：预约人数
     * @param xcxAutoSignIn：小程序自主签到
     * @param scanSignIn：扫码签到
     * @param signInBeforeMinutes：开课前多少分钟允许签到
     * @param startRuleRequestLimit：是否开启预约时间限制
     * @param startComingDayMinuteOffset：几点开放预约
     * @param startComingDays：可约近几天的课
     * @param endRuleRequestLimit：是否开启截止预约限制
     * @param endBeforeMinutes：截止预约时间
     * @param endBeforeUnit：截止预约时间单位
     * @param cancelRuleLimit：是否开启取消预约限制
     * @param cancelMinutes：截止取消预约时间
     * @param cancelUnit：截止取消预约时间单位
     **/
    public void saveGroupBookingRules(String id, boolean allowQueuing, int bookingSeatCount, boolean xcxAutoSignIn, boolean scanSignIn, int signInBeforeMinutes, boolean startRuleRequestLimit, int startComingDayMinuteOffset, int startComingDays, boolean endRuleRequestLimit, int endBeforeMinutes, String endBeforeUnit, boolean cancelRuleLimit, int cancelMinutes, String cancelUnit, DataUserInfo...dataUserInfos){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_saveGroupBookingRules")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject body = new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());
        body.put("id",id);  // 规则id
        body.put("allowQueuing",allowQueuing); // 是否允许排队
        body.put("bookingSeatCount",bookingSeatCount); // 预约席位
        body.put("xcxAutoSignIn",xcxAutoSignIn); // 小程序签到
        body.put("scanSignIn",scanSignIn); // 扫码签到
        body.put("signInBeforeMinutes",signInBeforeMinutes); // 开课前多久允许签到

        JSONObject bookingStartRuleRequest = new JSONObject(); // 预约时间限制
        if (startRuleRequestLimit){  // 开启预约时间限制
            bookingStartRuleRequest.put("bookingStartComingDayMinuteOffset",startComingDayMinuteOffset); // 几点开放预约
            bookingStartRuleRequest.put("bookingStartComingDays",startComingDays); // 可约近几天的课
        }
        bookingStartRuleRequest.put("limit",startRuleRequestLimit); // 是否开启预约时间限制
        body.put("bookingStartRuleRequest",bookingStartRuleRequest); // 预约时间限制

        JSONObject bookingEndRuleRequest = new JSONObject(); // 截止预约限制
        if (endRuleRequestLimit){
            bookingEndRuleRequest.put("bookingEndBeforeMinutes",endBeforeMinutes); // 截止预约前多长时间
            bookingEndRuleRequest.put("bookingEndBeforeUnit",endBeforeUnit); // 单位
        }
        bookingEndRuleRequest.put("limit",endRuleRequestLimit); // 截止预约限制
        body.put("bookingEndRuleRequest",bookingEndRuleRequest); //截止时间限制

        JSONObject cancelStartClassRuleRequest = new JSONObject(); // 取消开课限制
        cancelStartClassRuleRequest.put("limit",false);
        body.put("cancelStartClassRuleRequest",cancelStartClassRuleRequest);


        JSONObject cancelBookingRuleRequest = new JSONObject();
        if (cancelRuleLimit){
            cancelBookingRuleRequest.put("cancelBookingBeforeMinutes",cancelMinutes); // 开课前截止取消预约
            cancelBookingRuleRequest.put("cancelBookingBeforeUnit",cancelUnit); // 单位
        }
        cancelBookingRuleRequest.put("limit",cancelRuleLimit);
        body.put("cancelBookingRuleRequest",cancelBookingRuleRequest);

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

    }



    /**
     * @description:获取团课预约规则
     * @author: xuyamei
     * @date:  2024/5/13 16:27
     * @param
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getGroupBookingRules(){
        dataApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_getGroupBookingRules")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject body= new JSONObject();
        body.put("brandId",dataApi.getLoginInfo().getBrandId());
        body.put("studioId",dataApi.getLoginInfo().getStudioId());
        body.put("operatorId",dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);
        return dataApi.getBodyInJSON().getJSONObject("result");
    }
}
