package com.xiaomai.cases.lunar.reserve;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;

import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;


/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.lunar.reserve
 * @Author: xuyamei
 * @CreateTime: 2024-06-25  11:55
 * @Description:
 * @Version: 1.0
 */
public class TestMemberTimetable extends BaseTestImpl {
    @Resource(name = "userTools")
    UserTools userTools;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Reserve,"API_memberTimetable", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"xym");
        super.beforeTest();
    }


    @Test
    public void testMemberTimetable() {
        String memberId = userTools.getMemberInfo().getString("memberId");

        JSONObject body = new JSONObject();
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("startDate", TimeUtils.getTodayTime());
        body.put("endDate",TimeUtils.getTodayEndTime());
        body.put("courseChooseEnum","ALL");
        body.put("memberId",memberId);
        xmAppApi.doRequest(RequestType.JSON,params,body.toString(),headers).assetsSuccess(true);

    }


}
