package com.xiaomai.cases.polar.memberCard.MemberCardTimeSale;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component("memberCardTimeSaleTools")
public class MemberCardTimeSaleTools extends XMBaseTest {

    /**
     * @param
     * @description:B端查看秒杀活动列表
     * @author: yangjian
     * @param stat 活动状态
     **/
    public JSONObject getStudioActivityPage(String stat, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_getStudioActivityPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> status = new ArrayList<>();
        status.add(stat);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("states", status);//UNPUBLISHED未发布；WAITING未开始；PROCESSING进行中；ENDED已结束；ABNORMAL已失效
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:B端创建限时秒杀活动
     * @author: yangjian
     * @param membercardId 关联的会员卡ID
     * @param activityName 秒杀活动名称
     **/
    public JSONObject create(String membercardId,String activityName,Boolean publish, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_createfalshsale")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        List<String> applyMemberStates = new ArrayList<>();
        applyMemberStates.add("POTENTIAL");
        applyMemberStates.add("NORMAL");
        applyMemberStates.add("HISTORY");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityName", activityName);
        jsonObject.put("activityType", "SECKILL");//活动类型为秒杀
        jsonObject.put("endTime", TimeUtils.getTodayEndTime());//活动结束时间为今天24点
        jsonObject.put("startTime", TimeUtils.getTodayTime());//活动开始时间为今天0点
        jsonObject.put("applyMemberStates", applyMemberStates);//活动可参与用户
        jsonObject.put("autoCancelMinutes", "5");//自动取消订单时间
        jsonObject.put("commodityId", membercardId);//活动的会员卡商品
        jsonObject.put("commodityType", "MEMBER_CARD");//商品类型，目前仅有会员卡
        jsonObject.put("initSalesVolumeShow", "10");//初始秒杀数量显示
        jsonObject.put("purchaseNumberLimit", -1);//购买数量限制：不限制
        jsonObject.put("reserveReminder", true);//秒杀数量是否展示
        jsonObject.put("specialPrice", "0");//秒杀价格0元
        jsonObject.put("publish", publish);//是否发布
        jsonObject.put("stock", "10");//活动库存数
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());


        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }


    /**
     * @param
     * @description:B端搜索秒杀活动列表
     * @author: yangjian
     * @param activityNameLike 搜索内容
     **/
    public JSONObject getStudioActivityPage1(String activityNameLike, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_getStudioActivityPage")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);



        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityNameLike", activityNameLike);
        jsonObject.put("size", 10);
        jsonObject.put("current", 0);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:获取秒杀活动详情
     * @author: yangjian
     * @param activityId 活动ID
     **/
    public JSONObject getStudioActivityById(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_getStudioActivityById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:失效秒杀活动
     * @author: yangjian
     * @param activityId 活动ID
     **/
    public JSONObject studioSeckillInvalid(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_studioSeckill_invalid")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:删除秒杀活动
     * @author: yangjian
     * @param activityId 活动ID
     **/
    public JSONObject studioSeckillDeleteById(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_studioSeckill_deleteById")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:查看秒杀活动数据
     * @author: yangjian
     * @param activityId 活动ID
     **/
    public JSONObject getStatisticsData(String activityId, DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_getStatisticsData")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityId", activityId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }

    /**
     * @param
     * @description:查看秒杀活动数据
     * @author: yangjian
     * @param activityId 活动ID
     * @param supplierId

     **/
    public JSONObject pageVoucher(String activityId,String supplierId,DataUserInfo... dataUserInfos) {

        dataApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_pageVoucher")
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfos);
        //List<String> states = new ArrayList<>();
        //states.add(state);


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current", 0);
        jsonObject.put("size", 20);
        jsonObject.put("supplierId", supplierId);//取活动详情的sourceId
        //jsonObject.put("states", states);//WAITING"待支付, "ARREARS"部分支付, "CANCEL"、"TIMEOUT"已取消 ,"PAID"已完成 "DISCARD"已作废

        jsonObject.put("activityId", activityId);
        jsonObject.put("brandId", dataApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId", dataApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId", dataApi.getLoginInfo().getAdminId());

        dataApi.doRequest(RequestType.JSON, dataparams, jsonObject.toJSONString(), dataheadrs).assetsSuccess(true);
        JSONObject response = dataApi.getBodyInJSON();
        return response;
    }







}
