package com.xiaomai.cases.polar.reserve.personal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.coupon.CouponTools;
import com.xiaomai.cases.polar.course.CourseTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.cases.polar.reserve.ReserveTools;
import com.xiaomai.cases.polar.schedule.group.GroupScheduleTools;
import com.xiaomai.cases.polar.setting.courseCategory.CourseCategoryTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.XMJSONPath;
import org.springframework.util.CollectionUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 批量代预约一对多私教课
 *
 * @author adu
 * data 2024/11/4 14:16
 */

public class TestBatchReserve1vnPersonal extends BaseTestImpl {
    @Resource(name = "courseCategoryTools")
    CourseCategoryTools courseCategoryTools;
    @Resource(name = "courseTools")
    CourseTools courseTools;
    @Resource(name = "groupScheduleTools")
    GroupScheduleTools groupScheduleTools;
    @Resource(name = "couponTools")
    CouponTools couponTools;

    TestReservePerson testReservePerson = new TestReservePerson();

    @Resource(name = "reserveTools")
    ReserveTools reserveTools;
    CardTools cardTools = new CardTools();
    //获取目标日期范围的时间戳下周一～下周日
    String endDate = CommUtil.oneKeyGetNextWeekEndDay();
    String startDate = CommUtil.oneKeyGetNextWeekStartDay();

    private String benefitId;
    private String memberId;

    private String memberId2;

    private String course1vnId;
    private String coachedId = "1851503867506028545";

    private String areaIdAll = "1851832978975846403";
    private String categoryId = "";
    private String memberCardId;
    List<String> reserveIds = new ArrayList<>();

    JSONArray member2 = new JSONArray();
    JSONArray member1 = new JSONArray();

    List<String> reserveIds2 = new ArrayList<>(); //学员2的预约记录
    List<String> scheduleIdList = new ArrayList<>(); //课次ID
    List<JSONObject> scheduleTableInfo = new ArrayList<>();


    @BeforeClass
    @Override
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Reserve, "API_batchReservePersonal", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    /**
     * 造轮子如下
     * 存量员工：员工只授课私教 员工ID：1851503867506028545 （自动化批量代预约私教（勿动））
     * 提前给员工设置好私教时间，常规可约时间1. 周二，周四，周五 15：00～16：00，19：30～20：30  2.周六，周日 18：20～19：20
     * 存量学员：1816039970498064385，学员手机号：17682302508，姓名：李四-测试机吴彦祖
     * 存量私教课程1v1和1vN（没有会创建）
     * 私教预约设置：1对多私教预约人数设置，每个会员每节课最多可以约2个席位
     * 场地：私教场地专用：1851832978975846403，2个子场LV1：1851832978975846404，LV2：1851832978975846405
     */

    @Test(description = "测试批量代预约1vn私教课")
    public void testBatchReserve1vnPersonal() throws InterruptedException {
        //1：造轮子
        //1.1 获取目标教练对应的1vn私教课课程，没有则新建
        // 查询存量的课程分类
        categoryId = courseCategoryTools.getCourseCategoryPage("力量训练");
        courseTools.getPersonalPage("ON", 0, "", "", "ONE_TO_MANY", coachedId);
        int targetData = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        String targetAreaId = "1851832978975846403";
        //1.2 存量教练
        JSONArray coachIds = new JSONArray();
        coachIds.add(coachedId);
        //1.3 存量场地
        JSONArray areaIds = new JSONArray();
        areaIds.add(areaIdAll);
        if (targetData == 0) {
            //如果没有对应的私教课，则新建教练对应的私教课程
            course1vnId = courseTools.createPersonalCourse("小杜总自动化1vn私教课-批量代预约专用", categoryId, "STUDIO", "ONE_TO_MANY",
                    3, 1, coachIds, areaIds);

        } else {
            JSONObject obj = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream()
                    .filter(e -> !CollectionUtils.isEmpty(e.getJSONArray("areaIds"))).findFirst().orElse(null);
            if (null != obj) {
                course1vnId = obj.getString("brandCourseId");
                int size = obj.getJSONArray("areaIds").size();
                //获取可选场地的最后1个
                targetAreaId = obj.getJSONArray("areaIds").getString(size - 1);
            } else {
                //如果有对应的私教课，但是私教课没设置场地，那么再新建个私教课
                course1vnId = courseTools.createPersonalCourse("大杜总自动化1vn私教课-批量代预约专用", categoryId, "STUDIO", "ONE_TO_MANY",
                        3, 1, coachIds, areaIds);
            }
        }
        //预约时间
        String selectDate6 = CommUtil.oneKeyGetNextWeekXDay(12);//下周六 日期时间戳
        String selectDate7 = CommUtil.oneKeyGetNextWeekXDay(13);//下周日 日期时间戳

        //1.4 上课计划筛选条件准备好后，为防止有数据问题，先检查下私教课表，对应时间段是否有课次，如果有则删除课次
        reserveTools.getPersonalScheduleTable(Long.valueOf(startDate), Long.valueOf(endDate), course1vnId);
        List<String> scheduleIds = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups")
                .toJavaList(JSONObject.class)
                .stream()
                .filter(e -> selectDate6.equals(e.getString("date")) || selectDate7.equals(e.getString("date")))
                .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())//重新组建新的数据流
                .filter(object -> 1100 == object.getInteger("minuteOffset"))
                .map(o -> o.getString("scheduleId"))
                .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(scheduleIds)) {
            //如果目标时间有课次，则删除课次
            scheduleIds.stream().forEach(id -> {
                reserveTools.delPersonalScheduleItem(id);
            });

        }

        //2：根据筛选条件获取上课日期，并选择日期 周五，周六和周日
        Integer[] weekDaysArray = {5, 6, 7};//周五时间设置的是19：30
        List<Integer> weekdaysList = Arrays.asList(weekDaysArray);
        reserveTools.getPersonalBatchReserveTimeBlockList(course1vnId, coachedId, startDate, endDate, 2, 1100, 60, weekdaysList, targetAreaId);//18：20～20：20
        //check 返回结果是否和预期一致
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 3, "目标日期有3个，目前数量对不上");

        String conflictDate = CommUtil.oneKeyGetNextWeekXDay(11);//下周五日期时间戳
        JSONObject conflictObj = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").toJavaList(JSONObject.class).stream()
                .filter(e -> conflictDate.equals(e.getString("reserveDate"))).findFirst().orElse(null);
        Assert.assertTrue(null != conflictObj, "没有获取到下周五的数据");
        Assert.assertTrue(conflictObj.getBoolean("canReserve").equals(false), "下周五日期应该不能选择预约，因为设置的私教时间是19：30～20：30，现在返回的是可约，请检查");
        Assert.assertTrue("非私教可约时间".equals(conflictObj.getString("cannotReserveReason")), "下周五日期应该不能选择预约，因为没设置私教时间，原因应该是：非私教可约时间，现在返回的不是哦，请检查");

        //3：选择预约学员
        //3.1查询存量的学员，如果没有则新建，一对多私教课没课次时首次预约
        member1 = testReservePerson.createMember("1V3批量私教预约专用学员晨晨A", course1vnId);
        memberId = member1.getString(0);
        benefitId = member1.getString(1);
        memberCardId = member1.getString(2);

        //3.2操作确认预约
        List<JSONObject> reserveDayInfoList = new ArrayList<>();

        JSONObject selectDate2Ob = new JSONObject();
        selectDate2Ob.put("reserveDate", selectDate6);
        reserveDayInfoList.add(selectDate2Ob);
        JSONObject selectDate4Ob = new JSONObject();
        selectDate4Ob.put("reserveDate", selectDate7);
        reserveDayInfoList.add(selectDate4Ob);
        reserveTools.batchReservePersonal(1, memberId, benefitId, course1vnId, coachedId, 1100, reserveDayInfoList, 1, 60, targetAreaId);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        String taskId1VnA = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

        //4:任务中心check
        Thread.sleep(4000);
        couponTools.getStudioBatchTaskPage();
        Long goalTask = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(taskId1VnA)).count();
        Assert.assertTrue(goalTask == 1, "刚操作批量预约私教课，在任务中心查看，后端没返回目标数据");
        //4.1 check发送状态成功， 发送1个学员，2条成功，0条失败
        XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(taskId1VnA)).forEach(object ->
                Assert.assertTrue("SUCCESS".equals(object.getString("state")) && 2 == object.getInteger("totalNumber") && 0 == object.getInteger("failNumber") &&
                        2 == object.getInteger("successNumber"), "预约失败,请进任务中心查看错误报告,check是不是上课日期不在所选卡有效期内"));


        //5：查询课表，获取课次ID，预约记录ID，学员ID
        //下周六课表check
        reserveTools.getPersonalScheduleTable(Long.valueOf(selectDate6), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(6)), course1vnId);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").size() >= 1, "下周日私教课次刚预约生成1个课次，但是目前返回的不是至少1个课次");
        List<JSONObject> dataInfo6 = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups")
                .toJavaList(JSONObject.class)
                .stream()
                .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())//重新组建新的数据流
                .filter(object -> 1100 == object.getInteger("minuteOffset"))
                .map(o -> new JSONObject().fluentPut("scheduleId", o.getString("scheduleId"))
                        .fluentPut("reserveIds", o.getJSONArray("reserveIds"))
                ) //获取多个数据时new一个对象，用fluentPut放入数据
                .collect(Collectors.toList());
        Assert.assertTrue(dataInfo6.size() == 1, "目标数据只有1条，但是获取的到数据不等于1");
        //5.1查看对应课次中是否有对应的预约学员
        JSONObject getScheduleItemDetail = groupScheduleTools.getScheduleItemDetail(dataInfo6.get(0).getString("scheduleId"));

        Assert.assertTrue(getScheduleItemDetail.getJSONArray("memberReserveList").size() == 1 && memberId.equals(getScheduleItemDetail.getJSONArray("memberReserveList").getJSONObject(0).getJSONObject("member").getString("id")));


        //5.2 下周日课表check
        reserveTools.getPersonalScheduleTable(Long.valueOf(selectDate7), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(7)), course1vnId);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").size() >= 1, "下周日私教课次刚预约生成1个课次，但是目前返回的不是至少1个课次");
        List<JSONObject> dataInfo7 = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups")
                .toJavaList(JSONObject.class)
                .stream()
                .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                .filter(object -> 1100 == object.getInteger("minuteOffset"))
                .map(o -> new JSONObject().fluentPut("scheduleId", o.getString("scheduleId"))
                        .fluentPut("reserveIds", o.getJSONArray("reserveIds"))
                )
                .collect(Collectors.toList());
        Assert.assertTrue(dataInfo7.size() == 1, "目标数据只有1条，但是获取的到数据不等于1");
        //5.3查看对应课次详情中是否有对应的预约学员
        JSONObject getScheduleItemDetail7 = groupScheduleTools.getScheduleItemDetail(dataInfo7.get(0).getString("scheduleId"));
        Assert.assertTrue(getScheduleItemDetail.getJSONArray("memberReserveList").size() == 1 && memberId.equals(getScheduleItemDetail.getJSONArray("memberReserveList").getJSONObject(0).getJSONObject("member").getString("id")));

     /*
 在java的流式处理操作中，FlatMap是一种常用的操作，用于将一个流中的元素映射为多个元素，然后将这些元素合并为一个新的流。它能够帮助我们处理复杂的数据结构，简化代码逻辑。
什么是FlatMap操作
在java中，FlatMap是Stream类中的一个常用操作，其作用是将一个流中的元素映射为多个元素，并将这些元素合并到一个新的流中。它的定义如下:
FlatMap操作的返回值是一个新的Stream对象，其中包含了映射后的所有元素。
FlatMap操作的使用场景
FlatMap操作在处理复杂数据结构时非常有用。例如，当我们从一个列表中选取某个字段的值时，可以使用FlatMap操作来将每个元素中的列表转换为一个新的流，并从中选择指定的值。
另一个常见的使用场景是嵌套循环。当我们需要将两个列表中的所有元素进行组合时，可以使用FatMap操作来将这两个列表转换为两个新的流，并使用两个流的元素进行组合。
         */

        // 6 check 预约记录列表（比对预约记录ID）
        JSONArray getPageByStudio = reserveTools.getPageByStudio(course1vnId, "SUCCESS", "", coachedId, Long.valueOf(selectDate6), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(7)), memberId, "PERSONAL", "");
        Assert.assertTrue(getPageByStudio.size() >= 2, "下周已给学员批量代预约私教课2节，目前查到的相关记录不足2条，请检查");
        reserveIds = getPageByStudio.toJavaList(JSONObject.class).stream().map(o -> o.getString("id")).collect(Collectors.toList());
        List<String> tableReserveIds6 = dataInfo6.stream()
                .map(o -> o.getJSONArray("reserveIds").getString(0))
                .collect(Collectors.toList());
        List<String> tableReserveIds7 = dataInfo7.stream()
                .map(o -> o.getJSONArray("reserveIds").getString(0))
                .collect(Collectors.toList());

        Assert.assertTrue(reserveIds.containsAll(tableReserveIds6) && reserveIds.containsAll(tableReserveIds7), "约课后在约课记录页面未查询到相关信息");

        //7: check会员卡消耗记录中包含该记录锁定
        JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId, memberCardId).getJSONObject("result").getJSONArray("records");
        if (consumeRecord.size() > 0) {
            reserveIds.stream().forEach(e -> {
                Long count = consumeRecord.toJavaList(JSONObject.class).stream().filter(o -> e.equals(o.getString("resourceId")) && "RESERVE".equals(o.getString("consumeType")) && "-1.00".equals(o.getString("changeOfUsablePurchaseBalance"))).count();
                Assert.assertTrue(count == 1, "消耗记录中没有对应的已预约记录");
            });
        }

        // 8.学员2进行预约,一对多私教课已存在课次时给其他学员操作批量预约
        member2 = testReservePerson.createMember("1V3批量私教预约专用学员楷楷B", course1vnId);
        memberId2 = member2.getString(0);
        benefitId = member2.getString(1);
        memberCardId = member2.getString(2);

        // 8.1 根据筛选条件获取上课日期，并选择日期 周五，周六和周日
        Integer[] weekDaysArray2 = {5, 6, 7};//周五时间设置的是19：30
        List<Integer> weekdaysList2 = Arrays.asList(weekDaysArray2);
        reserveTools.getPersonalBatchReserveTimeBlockList(course1vnId, coachedId, startDate, endDate, 2, 1100, 60, weekdaysList2, targetAreaId);//18：20～20：20
        //check 返回结果是否和预期一致

        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").size() == 3, "目标日期有3个，目前数量对不上");
        List<JSONObject> reserveDayInfoList2 = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result").toJavaList(JSONObject.class).stream()
                .filter(o -> {
                    return selectDate6.equals(o.getString("reserveDate")) || selectDate7.equals(o.getString("reserveDate"));
                }).filter(o -> true == (o.getBoolean("canReserve")))
                .map(o -> {
                    o.remove("minuteOffset");
                    o.remove("canReserve");
                    return o;
                }).collect(Collectors.toList());

        //8.2 选好日期和学员操作批量预约check
        reserveTools.batchReservePersonal(1, memberId2, benefitId, course1vnId, coachedId, 1100, reserveDayInfoList2, 1, 60, targetAreaId);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        String taskId1VnB = XMJSONPath.readPath(dataApi.getApi_response(), "$.result");

        Thread.sleep(4000);
        couponTools.getStudioBatchTaskPage();
        Long goalTaskB = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(taskId1VnB)).count();
        Assert.assertTrue(goalTaskB == 1, "刚操作批量预约1vn私教课，在任务中心查看，后端没返回目标数据");
        //8.3 check发送状态成功， 发送1个学员，2条成功，0条失败
        XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").toJavaList(JSONObject.class).stream().filter(e ->
                e.getString("id").equals(taskId1VnB)).forEach(object ->
                Assert.assertTrue("SUCCESS".equals(object.getString("state")) && 2 == object.getInteger("totalNumber") && 0 == object.getInteger("failNumber") &&
                        2 == object.getInteger("successNumber")));

        //8.4 check 下周周五～周日的私教课课表
        reserveTools.getPersonalScheduleTable(Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(11)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(7)), course1vnId);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups").size() >= 2, "下周周五～周日私教课次刚预约生成2个课次，但是目前返回的不是至少2课次");

        scheduleTableInfo = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.timetableGroups")
                .toJavaList(JSONObject.class)
                .stream()
                .filter(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream().anyMatch(o -> 1100 == o.getInteger("minuteOffset") && 2 == o.getInteger("scheduledNum")))
                .map(e -> new JSONObject()
                        .fluentPut("date", e.getString("date"))
                        .fluentPut("timetableList", e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream().map(
                                o -> new JSONObject().fluentPut("scheduleId", o.getString("scheduleId"))
                                        .fluentPut("reserveIds", o.getJSONArray("reserveIds"))
                        ).collect(Collectors.toList()))
                ).collect(Collectors.toList());
        Assert.assertTrue(scheduleTableInfo.size() == 2, "目标数据只有2条且课次中学员有2个，但是获取的到数据不等于2");

        reserveIds2 = new ArrayList<>();
        // 8.5check 课次详情预约学员是否包含该会员
        scheduleIdList = scheduleTableInfo.stream()
                .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                .map(o -> o.getString("scheduleId")).collect(Collectors.toList());
        scheduleIdList.stream().forEach(s -> {
            JSONObject getScheduleItemDetail67 = groupScheduleTools.getScheduleItemDetail(s);
            Long goalMembercount = getScheduleItemDetail67.getJSONArray("memberReserveList").toJavaList(JSONObject.class).stream()
                    .filter(o -> o.getJSONObject("member").getString("id").contains(memberId2)).count();
            Assert.assertTrue(getScheduleItemDetail67.getJSONArray("memberReserveList").size() == 2 && goalMembercount == 1, "一对多私教课批量约课（已存在课次）后下周六日课次详情学员不在课次中");

            reserveIds2.add(getScheduleItemDetail67.getJSONArray("memberReserveList").toJavaList(JSONObject.class).stream()
                    .filter(o -> o.getJSONObject("member").getString("id").contains(memberId2)).map(e -> e.getString("id")).findFirst().orElse(null));

        });


        //8.6 check会员卡消耗记录中包含该记录锁定
        JSONArray consumeRecord2 = cardTools.fetchPageOfConsumeRecord(benefitId, memberCardId).getJSONObject("result").getJSONArray("records");
        if (consumeRecord2.size() > 0 && !CollectionUtils.isEmpty(reserveIds2)) {
            reserveIds2.stream().forEach(e -> {
                Long count = consumeRecord2.toJavaList(JSONObject.class).stream().filter(o -> e.equals(o.getString("resourceId")) && "RESERVE".equals(o.getString("consumeType")) && "-1.00".equals(o.getString("changeOfUsablePurchaseBalance"))).count();
                Assert.assertTrue(count == 1, "消耗记录中没有对应的已预约记录");
            });
        }

    }

    @Test(description = "删除课次", priority = 1)
    public void testDelReservePerson() {
        // 课次中的一个会员取消预约
        if (!CollectionUtils.isEmpty(reserveIds2) && !CollectionUtils.isEmpty(scheduleIdList)) {
            reserveIds2.stream().forEach(reserveId -> {
                reserveTools.cancelMemberReserve(reserveId, true);
                //获取对应预约记录的课次ID
                String scheduleId = scheduleTableInfo.stream()
                        .flatMap(e -> e.getJSONArray("timetableList").toJavaList(JSONObject.class).stream())
                        .filter(e -> e.getJSONArray("reserveIds").contains(reserveId))
                        .map(o -> o.getString("scheduleId")).findFirst().orElse(null);

                // check :课次还存在 且课次中不包含该学员,另外一个学员还在check
                JSONObject getScheduleItemDetail = groupScheduleTools.getScheduleItemDetail(scheduleId);
                Long goalMembercount = getScheduleItemDetail.getJSONArray("memberReserveList").toJavaList(JSONObject.class).stream()
                        .filter(o -> o.getJSONObject("member").getString("id").contains(memberId)).count();
                Assert.assertTrue(getScheduleItemDetail.getJSONArray("memberReserveList").size() == 1 && goalMembercount == 1, "一对多私教课预约2人，取消A学员的预约记录，目前课次详情中应该还有1个学员，且不是学员A，是学员B，但是断言结果不是这样的，请检查");

                // 删除该课次
                reserveTools.delPersonalScheduleItem(scheduleId);

                // 课次学员取消预约
                // check：课次已删除,课表没有该条数据
                JSONArray personalScheduleTable = reserveTools.getPersonalScheduleTable(Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(11)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(7)), course1vnId);
                boolean flag = true;
                if (personalScheduleTable != null) {
                    for (int i = 0; i < personalScheduleTable.size(); i++) {
                        if (personalScheduleTable.getJSONObject(i).getString("scheduleId").equals(scheduleId)) {
                            scheduleId = personalScheduleTable.getJSONObject(i).getString("scheduleId");
                            flag = false;
                            break;
                        }
                    }
                }
                Assert.assertTrue(flag, "取消约课后课次未删除");


                // check：会员详情 - 预约记录已取消
                JSONArray getPageByMember = reserveTools.getPageByMember(course1vnId, "RESERVE_CANCEL", "", coachedId, Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(11)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(7)), memberId2, "PERSONAL");
                for (int i = 0; i < getPageByMember.size(); i++) {
                    if (getPageByMember.getJSONObject(i).getString("id").equals(reserveId)) {
                        Assert.assertEquals(getPageByMember.getJSONObject(i).getString("reserveState"), "RESERVE_CANCEL", "取消约课状态不是已取消");
                    }
                }

                // check ：预约记录列表中已取消
                JSONArray getPageByStudio = reserveTools.getPageByStudio(course1vnId, "RESERVE_CANCEL", "", coachedId, Long.valueOf(CommUtil.oneKeyGetNextWeekXDay(11)), Long.valueOf(CommUtil.oneKeyGetNextWeekEndXDay(7)), memberId2, "PERSONAL", "");
                ;
                for (int i = 0; i < getPageByStudio.size(); i++) {
                    if (getPageByStudio.getJSONObject(i).getString("id").equals(reserveId)) {
                        Assert.assertEquals(getPageByStudio.getJSONObject(i).getString("reserveState"), "RESERVE_CANCEL", "取消约课状态不是已取消");

                    }
                }

                // check ： 会员卡消耗记录中包含该记录锁定的次数释放
                JSONArray consumeRecord = cardTools.fetchPageOfConsumeRecord(benefitId, memberCardId).getJSONObject("result").getJSONArray("records");
                String[] result2 = new String[]{"resourceId", "consumeType", "changeOfUsablePurchaseBalance"};
                String[] respect = new String[]{reserveId, "CANCEL_RESERVE", "1.00"};
                String[] message1 = new String[]{"会员卡消耗记录中记录的资源id与实际约课记录id不符合", "会员卡消耗记录中记录的资源id与实际约课记录类型不符合", "会员卡消耗记录中记录的资源id与实际约课记录余额不符合"};
                for (int i = 0; i < result2.length; i++) {
                    Assert.assertEquals(consumeRecord.getJSONObject(0).getString(result2[i]), respect[i], message1[i]);
                }

            });

        }
    }
}

    