package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-04-19  16:09
 * @Description: 校验角色权限配置是否重复
 * @Version: 1.0
 */
public class TestCheckPermConfigDup extends BaseTestImpl {

    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_checkPermConfigDup", LoginAccount.XYM_DEV, Terminal.B,"xym");
        super.beforeTest();
    }

    @DataProvider()
    public Object[][] data(){
        return new Object[][]{
                {"{\"permCodes\": [\"FitHeadPage\", \"FitCluePrivate\", \"FitSeeValidMember\", \"FitCluePublic\", \"FitAddClue\", \"FitEditClue\", \"FitReleaseClue\"],\n" +
                        "        \"configMap\": {\n" +
                        "        \"memberAccess\": false,\n" +
                        "        \"scheduleAccess\": false,\n" +
                        "        \"reserveAccess\": false,\n" +
                        "        \"followUpAccess\": false,\n" +
                        "        \"importAccess\": false,\n" +
                        "        \"exportAccess\": false,\n" +
                        "        \"taskAccess\": false,\n" +
                        "        \"potentialPhoneMask\": true,\n" +
                        "        \"memberPhoneMask\": false,\n" +
                        "        \"historyPhoneMask\": true}}",true}, // 存在有相同权限的角色
                {"{\n" +
                        "        \"permCodes\": [\"FitHeadPage\", \"FitCluePublic\", \"FitAddClue\", \"FitEditClue\", \"FitReleaseClue\"],\n" +
                        "        \"configMap\": {\n" +
                        "        \"memberAccess\": false,\n" +
                        "        \"scheduleAccess\": false,\n" +
                        "        \"reserveAccess\": false,\n" +
                        "        \"followUpAccess\": false,\n" +
                        "        \"importAccess\": false,\n" +
                        "        \"exportAccess\": false,\n" +
                        "        \"taskAccess\": false,\n" +
                        "        \"potentialPhoneMask\": true,\n" +
                        "        \"memberPhoneMask\": false,\n" +
                        "        \"historyPhoneMask\": true}}",false}  // 不存在的角色

        };
    }
    @Test(dataProvider = "data")
    public void testCheckPermConfigDup(String body,boolean flag){
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        JSONObject response = xmAppApi.getBodyInJSON();
        Assert.assertEquals(response.getJSONArray("result").size()>0,flag,"校验角色权限配置是否重复");

    }

}



