package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.studioConfig.ConfigTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-04-19  17:22
 * @Description:
 * @Version: 1.0
 */
public class TestStudioRoleCreate extends BaseTestImpl {

    @Resource(name = "adminTools")
    AdminTools adminTools;

    @Resource(name = "configTools")
    ConfigTools configTools;

    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_studioRole_create", LoginAccount.XYM_DEV, Terminal.B,"xym");
        super.beforeTest();
    }
    @Test(description = "新建角色 --> 查询列表是否有该角色 --> 删除新建的角色")
    public void testStudioRoleCreate(){
        String body = "{\"roleName\": \"角#色设定##\",\n" +
                "        \"permissions\":\n" +
                "         [\"FitHeadPage\", \"FitViewExperienceCard\", \"FitManageExperienceCard\", \"FitViewSoldExperienceCard\", \"FitManageSoldExperienceCard\", \"FitSeeMember\", \"FitLoseMember\", \"FitEditMember\", \"FitAllocateMember\", \"FitSeeMemberCard\", \"FitManageMemberCard\", \"FitSeeSoldMemberCard\", \"FitManageSoldMemberCard\", \"FitSeeTrainingCamp\", \"FitEditTrainingCamp\", \"FitSeeSoldTrainingCamp\", \"FitEditSoldTrainingCamp\", \"FitSeeGroupSchedule\", \"FitManageGroupSchedule\", \"FitSeePersonalSchedule\", \"FitManagePersonalSchedule\", \"FitManageTrainingCampSchedule\", \"FitBooking\", \"FitCancelBooking\", \"FitSign\", \"FitSeeBookingRecord\", \"FitIncomeExpense\", \"FitSeeOrder\", \"FitEditOrder\", \"FitSeeXmPay\", \"FitManageXmPay\", \"FitLog\", \"FitSeeAdmin\", \"FitInfo\", \"FitBrandInfo\", \"FitReminderSet\", \"FitSms\", \"FitLabel\", \"FitCourseCategory\", \"FitVenue\", \"FitBookingRuleSet\", \"FitSaleRule\", \"FitPayment\"],\n" +
                "        \"configMap\": {\n" +
                "        \"memberAccess\": false,\n" +
                "        \"scheduleAccess\": false,\n" +
                "        \"reserveAccess\": false,\n" +
                "        \"followUpAccess\": true,\n" +
                "        \"importAccess\": false,\n" +
                "        \"exportAccess\": true,\n" +
                "        \"taskAccess\": false,\n" +
                "        \"potentialPhoneMask\": true,\n" +
                "        \"memberPhoneMask\": true,\n" +
                "        \"historyPhoneMask\": true\n" +
                "        }}";

        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        JSONObject result = adminTools.studioRoleListByStudioId();
        JSONArray jsonArray = result.getJSONObject("result").getJSONArray("studioRoles");
        boolean flag = false;
        // 角色id
        String id = "";
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject.getString("name").equals("角#色设定##")){
                flag = true;
                String roleCode = jsonObject.getString("code");
                id = jsonObject.getString("id");

                JSONObject response = adminTools.getDetailStudioRole(roleCode);
                adminTools.studioRoleRemove(roleCode);
                Assert.assertEquals(response.getJSONObject("result").getString("name"),"角#色设定##","查询角色详情时新建与详情不一致");
                break;
            }
        }
        // 校验1：创建角色是否成功
        Assert.assertEquals(flag,true,"创建角色失败");

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 校验2：查询日志是否有创建员工角色记录
        body = "{\"current\":0,\"size\":10,\"domainId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"opEventKey\":\"ADD_ROLE\"}";
        JSONObject response = configTools.getOpauditPage(body);
        Assert.assertEquals(response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("target").getString("targetId"),id,"添加角色未生成操作日志");


    }
}
