package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.polar.studioConfig.ConfigTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.admin
 * @Author: xuyamei
 * @CreateTime: 2024-04-22  14:13
 * @Description: 编辑角色
 * @Version: 1.0
 */
public class TestStudioRoleEdit extends BaseTestImpl {

    @Resource(name = "adminTools")
    AdminTools adminTools;
    @Resource(name = "configTools")
    ConfigTools configTools;
    @BeforeClass
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Admin,"API_studioRole_edit", LoginAccount.XYM_DEV, Terminal.B,"xym");
        super.beforeTest();
    }
    private String roleCode;
    private boolean flag;


    @Test(description = "创建角色-->编辑角色 --> 删除角色")
    public void testStudioRoleEdit(){
        // 创建角色
        adminTools.createStudioRole("准备角色");
        JSONObject result = adminTools.studioRoleListByStudioId();
        JSONArray jsonArray = result.getJSONObject("result").getJSONArray("studioRoles");
        // 角色id
        String id = "";
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (jsonObject.getString("name").equals("准备角色")){
                roleCode = jsonObject.getString("code");
                id = jsonObject.getString("id");
                flag = true;
                break;
            }
        }
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        // 编辑角色
        String body = "{\"roleCode\": \""+roleCode+"\",\n" +
                "        \"roleName\": \"编辑角色名称\",\n" +
                "        \"permissions\": [\"FitHeadPage\", \"FitSeeFollowUpRecord\", \"FitViewExperienceCard\", \"FitSeeMember\", \"FitSeeMemberCard\"],\n" +
                "        \"configMap\": {\n" +
                "        \"memberAccess\": false,\n" +
                "        \"scheduleAccess\": false,\n" +
                "        \"reserveAccess\": false,\n" +
                "        \"followUpAccess\": true,\n" +
                "        \"importAccess\": false,\n" +
                "        \"exportAccess\": true,\n" +
                "        \"taskAccess\": true,\n" +
                "        \"potentialPhoneMask\": true,\n" +
                "        \"memberPhoneMask\": true,\n" +
                "        \"historyPhoneMask\": true\n" +
                "        }}";


        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);

        // 查看详情
        JSONObject response = adminTools.getDetailStudioRole(roleCode);
        adminTools.studioRoleRemove(roleCode); // 删除角色
        flag = false; // 角色删除标识
        Assert.assertEquals(response.getJSONObject("result").getString("name"),"编辑角色名称","编辑角色名称失败");

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        // 校验2：查询日志是否有编辑员工角色记录
        body = "{\"current\":0,\"size\":10,\"domainId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"opEventKey\":\"EDIT_ROLE\"}";
        response = configTools.getOpauditPage(body);
        Assert.assertEquals(response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONObject("target").getString("targetId"),id,"编辑角色未生成操作日志");



    }

    @Test(description = "清除增量数据，防止没有删除的情况",priority = 1)
    public void del(){
        if (flag){
            adminTools.studioRoleRemove(roleCode);
        }
    }


}
