package com.xiaomai.cases.polar.clue;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/3/14 16:03
 */
public class MemberTools extends BaseTestImpl {

    //创建潜在会员
    public JSONObject create(String name,String phone,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_create")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("creatorId",xmAppApi.getLoginInfo().getAdminId());
        object.put("status","POTENTIAL");
        object.put("name",name);
        object.put("phone",phone);
        object.put("gender","UNKNOWN");

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //是否存在相同手机号
    public JSONObject checkPhoneDuplicate(String phone,String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_checkPhoneDuplicate")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("phone",phone);
        object.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //会员详情
    public JSONObject getDetailById(String memberId,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_findDetailById")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("memberId",memberId);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //搜索潜在会员
    public JSONObject searchMember(DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_searchMember")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject studioFilter = new JSONObject();
        studioFilter.put("studioId",xmAppApi.getLoginInfo().getStudioId());

        List statusList = new ArrayList();
        statusList.add("POTENTIAL");

        JSONObject object = new JSONObject();
        object.put("current",0);
        object.put("size",20);
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioFilter",studioFilter);
        object.put("statusList",statusList);

        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }

    //搜索全部会员
    public JSONObject commonSearch(String content,DataUserInfo...userInfos){
        dataApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_commonSearch")
                .setTerminal(Terminal.B);

        super.beforeDataRequest(userInfos);

        JSONObject object = new JSONObject();
        object.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        object.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        object.put("content",content);


        dataApi.doRequest(RequestType.JSON,dataparams,object.toString(),dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }
}
