package com.xiaomai.cases.polar.member;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;


public class TestSearch extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Clue)
                .setApiName("API_searchMember")
                .setLoginUser(LoginAccount.YFF_DEV)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"NORMAL"},
                {"HISTORY"}
        };
    }
    @Test(description = "获取会员管理（正式会员/流失会员）列表",dataProvider = "dataProvider")
    public void testSearch(String status){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());

        JSONObject studioFilter=new JSONObject();
        studioFilter.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("studioFilter",studioFilter);

        JSONArray statusList=new JSONArray();
        statusList.add(status);
        jsonObject.put("statusList",statusList);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals("true",success,"获取会员管理（正式会员/流失会员）列表失败");

    }

    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {"NORMAL"},
                {"HISTORY"}
        };
    }
    @Test(description = "筛选会员管理（正式会员/流失学员）列表来源、当前创建人、性别",dataProvider = "dataProvider1")
    public void testSearchResource(String status){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());

        JSONObject studioFilter=new JSONObject();
        studioFilter.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("studioFilter",studioFilter);

        JSONArray statusList=new JSONArray();
        statusList.add(status);
        jsonObject.put("statusList",statusList);
        jsonObject.put("resourceId","1");
        jsonObject.put("creatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("gender","WOMEN");


        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals("true",success,"筛选会员管理（正式会员/流失学员）列表来源、当前创建人、性别失败");

    }
}
