package com.xiaomai.cases.polar.membercluster;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 编辑会员分群
 *
 * @author adu
 * data 2024/10/29 15:05
 */

public class TestEditMemberCluster extends BaseTestImpl {
    @Resource(name = "memberClusterTools")
    MemberClusterTools memberClusterTools;
    String name = "";
    String clusterId = "";

    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Membercluster, "API_editMemberCluster", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "测试编辑人群")
    public void testEditMemberCluster() {

        //先查看人群列表数据，超过20个时，做下删除处理
        memberClusterTools.getMemberClusterList();
        if("最多只能新建20个，已达上限".equals(XMJSONPath.readPath(dataApi.getApi_response(), "$.message"))){
            //删除人群（过滤掉存量的2条数据）
            XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").toJavaList(JSONObject.class).stream()
                    .filter(object ->! "满足所有条件便签课程和储值卡（勿动）".equals(object.getString("name"))&& ! "满足任意一个条件会员分群（勿动）".equals(object.getString("name")))
                    .map(o->o.getString("id"))
                    .collect(Collectors.toList())
                    .stream()
                    .forEach(s -> {memberClusterTools.deleteMemberCluster(s);} );
        }
        //1.创建人群
        //1.1 人群名称验重
        name = "用于自动化测试编辑会员分群动态数据";
        memberClusterTools.memberClusterDuplicateCheck(name);
        System.out.println(XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        if ("true".equals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result"))) {//true 是有异常重名了，false 是无重名的
            name = "自动化测试编辑人群信息" + RandomStringUtil.randomString(6);
        } else {
            Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == true && Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.result")) == false, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        }
        //1.2 创建人群
        List<JSONObject> ruleList = new ArrayList<>();
        JSONObject ruleTypeTag = new JSONObject();
        List<String> tags = new ArrayList<>();
        tags.add("1850100465387134978");
        tags.add("1834827617041047554");
        ruleTypeTag.put("ruleType", "TAG");
        ruleTypeTag.put("tags", tags);
        ruleList.add(ruleTypeTag);

        JSONObject ruleTypeMember = new JSONObject();
        ruleTypeMember.put("ruleType", "MEMBER_CARD_COURSE_LEFT_BALANCE");
        ruleTypeMember.put("value", true);
        ruleTypeMember.put("lowerLimit", "60");
        ruleTypeMember.put("upperLimit", "62");
        ruleTypeMember.put("tags", null);
        ruleList.add(ruleTypeMember);


        JSONObject ruleTypeDeposit = new JSONObject();
        ruleTypeDeposit.put("ruleType", "DEPOSIT_CARD_LEFT_BALANCE");
        ruleTypeDeposit.put("value", true);
        ruleTypeDeposit.put("lowerLimit", "900");
        ruleTypeDeposit.put("upperLimit", "999");
        ruleTypeDeposit.put("tags", null);
        ruleList.add(ruleTypeDeposit);
        clusterId = memberClusterTools.createMemberCluster(name, "", "YES", ruleList);
        //1.3.查看列表，check是否包含刚创建的人群
        memberClusterTools.getMemberClusterList();
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result")
                .toJavaList(JSONObject.class).stream()
                .filter(e -> e.getString("id")
                        .equals(clusterId)).count() == 1, "列表中没获取到刚创建的会员分群（满足所有条件）");
        //2.编辑人群
        JSONObject body = new JSONObject();
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        String editName = name + "名字被编辑过了哈" + RandomStringUtil.randomString(3);
        body.put("name", editName);
        body.put("requireFullHit", "NO");
        body.put("ruleList", ruleList);
        String description = "自动化测试编辑人群信息，修改人群范围和人群定义";
        body.put("description", description);
        ruleList.remove(ruleTypeTag);
        body.put("ruleList", ruleList);
        body.put("id", clusterId);
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(xmAppApi.getApi_response(), "$.success")) == true, "调用接口返回结果：" + XMJSONPath.readPath(xmAppApi.getApi_response(), "$.message"));

        //2.1 check 编辑内容是否生效
        memberClusterTools.getMemberClusterDetail(clusterId);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.requireFullHit"), "NO");
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.name"), editName);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.description"), description);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.displayRuleList"), "会员卡课程剩余次数60~62次、储值卡剩余金额900~999元");
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.ruleList").size() == 2, "编辑后人群定义规则不是剩余2个，请检查");

        //3.操作定向运营（刚创建的人群未操作更新时，操作定向运营时接口也要拦截check）
        memberClusterTools.batchMessagePushForMemberCluster(clusterId, "WECHAT_MEMBER_CARD");
        Assert.assertTrue(Boolean.valueOf(XMJSONPath.readPath(dataApi.getApi_response(), "$.success")) == false, "调用接口返回结果：" + XMJSONPath.readPath(dataApi.getApi_response(), "$.message"));
        Assert.assertTrue("分群数据尚未收集，请先更新分群数据后再操作".equals(XMJSONPath.readPath(dataApi.getApi_response(), "$.message")), "还没更新人数，人群数量为0，所以操作定向运营要拦截下，目前接口返回数据不是这个请检查");

    }

    @Test(description = "删除此case创建的会员分群",priority = 1)
    public void delData() {

        if (!StringUtils.isEmpty(this.clusterId)) {
            memberClusterTools.deleteMemberCluster(clusterId);
        }

    }
}

    